/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.graphvisualizer.plugin.graphview;

import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.GraphInitializedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeAddedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeRemovedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeTypeSwitchEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.bus.HandleAlgorithmEventException;
import ai.libs.jaicore.graphvisualizer.events.gui.GUIEvent;
import ai.libs.jaicore.graphvisualizer.plugin.IGUIPluginController;
import ai.libs.jaicore.graphvisualizer.plugin.controlbar.ResetEvent;
import ai.libs.jaicore.graphvisualizer.plugin.graphview.GraphViewPluginModel;
import ai.libs.jaicore.graphvisualizer.plugin.graphview.ViewGraphManipulationException;
import ai.libs.jaicore.graphvisualizer.plugin.timeslider.GoToTimeStepEvent;
import java.util.Arrays;
import java.util.Collections;

public class GraphViewPluginController
implements IGUIPluginController {
    private GraphViewPluginModel model;

    public GraphViewPluginController(GraphViewPluginModel model) {
        this.model = model;
    }

    @Override
    public void handleAlgorithmEvent(AlgorithmEvent algorithmEvent) throws HandleAlgorithmEventException {
        try {
            if (GraphInitializedEvent.class.isInstance(algorithmEvent)) {
                GraphInitializedEvent graphInitializedEvent = (GraphInitializedEvent)algorithmEvent;
                this.handleGraphInitializedEvent(graphInitializedEvent);
            } else if (NodeAddedEvent.class.isInstance(algorithmEvent)) {
                NodeAddedEvent nodeAddedEvent = (NodeAddedEvent)algorithmEvent;
                this.handleNodeAddedEvent(nodeAddedEvent);
            } else if (NodeRemovedEvent.class.isInstance(algorithmEvent)) {
                NodeRemovedEvent nodeRemovedEvent = (NodeRemovedEvent)algorithmEvent;
                this.handleNodeRemovedEvent(nodeRemovedEvent);
            } else if (NodeTypeSwitchEvent.class.isInstance(algorithmEvent)) {
                NodeTypeSwitchEvent nodeTypeSwitchEvent = (NodeTypeSwitchEvent)algorithmEvent;
                this.handleNodeTypeSwitchEvent(nodeTypeSwitchEvent);
            }
        }
        catch (ViewGraphManipulationException exception) {
            throw new HandleAlgorithmEventException("Encountered a problem while handling graph event " + algorithmEvent + " .", exception);
        }
    }

    private void handleGraphInitializedEvent(GraphInitializedEvent<?> graphInitializedEvent) throws ViewGraphManipulationException {
        this.model.addNode(graphInitializedEvent.getRoot(), Collections.emptyList(), "root");
    }

    private void handleNodeAddedEvent(NodeAddedEvent<?> nodeReachedEvent) throws ViewGraphManipulationException {
        this.model.addNode(nodeReachedEvent.getNode(), Arrays.asList(nodeReachedEvent.getParent()), nodeReachedEvent.getType());
    }

    private void handleNodeTypeSwitchEvent(NodeTypeSwitchEvent<?> nodeTypeSwitchEvent) throws ViewGraphManipulationException {
        this.model.switchNodeType(nodeTypeSwitchEvent.getNode(), nodeTypeSwitchEvent.getType());
    }

    private void handleNodeRemovedEvent(NodeRemovedEvent<?> nodeRemovedEvent) throws ViewGraphManipulationException {
        this.model.removeNode(nodeRemovedEvent.getNode());
    }

    @Override
    public void handleGUIEvent(GUIEvent guiEvent) {
        if (guiEvent instanceof ResetEvent) {
            this.model.reset();
        } else if (guiEvent instanceof GoToTimeStepEvent) {
            this.model.reset();
        }
    }
}

