/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.graphvisualizer.plugin.graphview;

import ai.libs.jaicore.graphvisualizer.plugin.IGUIPluginView;
import ai.libs.jaicore.graphvisualizer.plugin.graphview.GraphMouseListener;
import ai.libs.jaicore.graphvisualizer.plugin.graphview.GraphViewPluginModel;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import org.graphstream.stream.Sink;
import org.graphstream.ui.fx_viewer.FxViewPanel;
import org.graphstream.ui.fx_viewer.FxViewer;
import org.graphstream.ui.view.Viewer;
import org.graphstream.ui.view.ViewerListener;
import org.graphstream.ui.view.ViewerPipe;

public class GraphViewPluginView
implements IGUIPluginView {
    private GraphViewPluginModel model = new GraphViewPluginModel(this);
    private FxViewer fxViewer = new FxViewer(this.model.getGraph(), Viewer.ThreadingModel.GRAPH_IN_ANOTHER_THREAD);
    private BorderPane graphParentLayout;

    public GraphViewPluginView() {
        this.fxViewer.enableAutoLayout();
        this.graphParentLayout = new BorderPane();
        this.initializeGraphMouseListener();
    }

    private void initializeGraphMouseListener() {
        ViewerPipe viewerPipe = this.fxViewer.newViewerPipe();
        GraphMouseListener graphMouseListener = new GraphMouseListener(this.model, viewerPipe);
        viewerPipe.addViewerListener((ViewerListener)graphMouseListener);
        viewerPipe.addSink((Sink)this.model.getGraph());
        Thread listenerThread = new Thread(graphMouseListener);
        listenerThread.start();
    }

    @Override
    public Node getNode() {
        FxViewPanel fxViewPanel = (FxViewPanel)this.fxViewer.addDefaultView(false);
        this.graphParentLayout.setCenter((Node)fxViewPanel);
        return this.graphParentLayout;
    }

    @Override
    public void update() {
    }

    @Override
    public String getTitle() {
        return "Search Graph Viewer";
    }

    public GraphViewPluginModel getModel() {
        return this.model;
    }
}

