/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.graphvisualizer.plugin.nodeinfo;

import ai.libs.jaicore.graphvisualizer.plugin.IGUIPluginView;
import ai.libs.jaicore.graphvisualizer.plugin.nodeinfo.NodeInfoGUIPluginModel;
import ai.libs.jaicore.graphvisualizer.plugin.nodeinfo.NodeInfoGenerator;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;

public class NodeInfoGUIPluginView<N>
implements IGUIPluginView {
    private NodeInfoGUIPluginModel<N> model = new NodeInfoGUIPluginModel(this);
    private NodeInfoGenerator<N> nodeInfoGenerator;
    private String title;
    private WebEngine webViewEngine;

    public NodeInfoGUIPluginView(NodeInfoGenerator<N> nodeInfoGenerator, String title) {
        this.nodeInfoGenerator = nodeInfoGenerator;
        this.title = title;
    }

    public NodeInfoGUIPluginView(NodeInfoGenerator<N> nodeInfoGenerator) {
        this(nodeInfoGenerator, "Node Info View");
    }

    @Override
    public Node getNode() {
        WebView htmlView = new WebView();
        this.webViewEngine = htmlView.getEngine();
        this.webViewEngine.loadContent("<i>No node selected</i>");
        return htmlView;
    }

    @Override
    public void update() {
        N currentlySelectedNode = this.model.getCurrentlySelectedNode();
        String nodeInfoOfCurrentlySelectedNode = this.nodeInfoGenerator.generateInfoForNode(currentlySelectedNode);
        Platform.runLater(() -> this.webViewEngine.loadContent(nodeInfoOfCurrentlySelectedNode));
    }

    public NodeInfoGUIPluginModel<N> getModel() {
        return this.model;
    }

    @Override
    public String getTitle() {
        return this.title;
    }
}

