/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.graphvisualizer.plugin.solutionperformanceplotter;

import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginView;
import ai.libs.jaicore.graphvisualizer.plugin.solutionperformanceplotter.SolutionPerformanceTimelinePluginController;
import ai.libs.jaicore.graphvisualizer.plugin.solutionperformanceplotter.SolutionPerformanceTimelinePluginModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import org.apache.commons.math3.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolutionPerformanceTimelinePluginView
extends ASimpleMVCPluginView<SolutionPerformanceTimelinePluginModel, SolutionPerformanceTimelinePluginController, LineChart<Number, Number>> {
    private Logger logger = LoggerFactory.getLogger(SolutionPerformanceTimelinePluginView.class);
    private final XYChart.Series<Number, Number> performanceSeries;
    private int nextIndexToDisplay = 0;

    public SolutionPerformanceTimelinePluginView(SolutionPerformanceTimelinePluginModel model) {
        super(model, new LineChart((Axis)new NumberAxis(), (Axis)new NumberAxis()));
        ((LineChart)this.getNode()).getXAxis().setLabel("elapsed time (s)");
        ((LineChart)this.getNode()).setTitle(this.getTitle());
        this.performanceSeries = new XYChart.Series();
        ((LineChart)this.getNode()).getData().add(this.performanceSeries);
    }

    @Override
    public void update() {
        List<Pair<Integer, Double>> events = ((SolutionPerformanceTimelinePluginModel)this.getModel()).getTimedPerformances();
        ArrayList<XYChart.Data> values = new ArrayList<XYChart.Data>();
        while (this.nextIndexToDisplay < events.size()) {
            Pair<Integer, Double> entry = events.get(this.nextIndexToDisplay);
            values.add(new XYChart.Data((Object)((Integer)entry.getKey() / 1000), entry.getValue()));
            ++this.nextIndexToDisplay;
        }
        this.logger.info("Adding {} values to chart.", (Object)values.size());
        Platform.runLater(() -> this.performanceSeries.getData().addAll((Collection)values));
    }

    @Override
    public String getTitle() {
        return "Solution Performance Timeline";
    }

    @Override
    public void clear() {
        this.nextIndexToDisplay = 0;
        this.performanceSeries.getData().clear();
    }

    public int getNextIndexToDisplay() {
        return this.nextIndexToDisplay;
    }
}

