/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.graphvisualizer.plugin.timeslider;

import ai.libs.jaicore.graphvisualizer.events.gui.DefaultGUIEventBus;
import ai.libs.jaicore.graphvisualizer.plugin.IGUIPluginView;
import ai.libs.jaicore.graphvisualizer.plugin.timeslider.GoToTimeStepEvent;
import ai.libs.jaicore.graphvisualizer.plugin.timeslider.TimeSliderGUIPluginModel;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.layout.VBox;

public class TimeSliderGUIPluginView
implements IGUIPluginView {
    private TimeSliderGUIPluginModel model = new TimeSliderGUIPluginModel(this);
    private Slider timestepSlider;

    @Override
    public Node getNode() {
        VBox timestepSliderLayout = new VBox();
        timestepSliderLayout.setAlignment(Pos.CENTER);
        this.timestepSlider = new Slider(0.0, 1.0, 0.0);
        this.timestepSlider.setShowTickLabels(true);
        this.timestepSlider.setShowTickMarks(true);
        this.timestepSlider.setMajorTickUnit(25.0);
        this.timestepSlider.setMinorTickCount(5);
        this.timestepSlider.setOnMouseReleased(event -> this.handleInputEvent());
        this.timestepSlider.setOnKeyPressed(event -> this.handleInputEvent());
        this.timestepSlider.setOnKeyReleased(event -> this.handleInputEvent());
        timestepSliderLayout.getChildren().add((Object)this.timestepSlider);
        Label timestepSliderLabel = new Label("Timestep");
        timestepSliderLayout.getChildren().add((Object)timestepSliderLabel);
        return timestepSliderLayout;
    }

    public synchronized void handleInputEvent() {
        DefaultGUIEventBus.getInstance().postEvent(new GoToTimeStepEvent((int)this.timestepSlider.getValue()));
    }

    @Override
    public void update() {
        this.timestepSlider.setValue((double)this.model.getCurrentTimeStep());
        this.timestepSlider.setMax((double)this.model.getMaximumTimeStep());
        if (this.model.isPaused() && this.timestepSlider.isDisabled()) {
            this.timestepSlider.setDisable(false);
        } else if (!this.model.isPaused() && !this.timestepSlider.isDisabled()) {
            this.timestepSlider.setDisable(true);
        }
    }

    @Override
    public String getTitle() {
        return "Time Slider";
    }

    public TimeSliderGUIPluginModel getModel() {
        return this.model;
    }
}

