/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.logic.fol.structure;

import ai.libs.jaicore.logic.fol.structure.Clause;
import ai.libs.jaicore.logic.fol.structure.ConstantParam;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.LiteralParam;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.logic.fol.structure.VariableParam;
import ai.libs.jaicore.logic.fol.util.LogicUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CNFFormula
extends HashSet<Clause> {
    public CNFFormula() {
    }

    public CNFFormula(Clause c) {
        this.add(c);
    }

    public CNFFormula(Monom m) {
        for (Literal l : m) {
            this.add(new Clause(l));
        }
    }

    public CNFFormula(Collection<Clause> c) {
        this.addAll(c);
    }

    public CNFFormula(Set<Clause> clauses, Map<VariableParam, ? extends LiteralParam> mapping) {
        for (Clause c : clauses) {
            Clause replacedClause = new Clause(c, mapping);
            if (replacedClause.isEmpty()) {
                this.clear();
                this.add(new Clause("A"));
                this.add(new Clause("!A"));
                return;
            }
            if (replacedClause.isTautological()) continue;
            this.add(replacedClause);
        }
    }

    public Set<VariableParam> getVariableParams() {
        HashSet<VariableParam> vars = new HashSet<VariableParam>();
        for (Clause c : this) {
            vars.addAll(c.getVariableParams());
        }
        return vars;
    }

    public Set<ConstantParam> getConstantParams() {
        HashSet<ConstantParam> constants = new HashSet<ConstantParam>();
        for (Clause c : this) {
            constants.addAll(c.getConstantParams());
        }
        return constants;
    }

    public boolean hasDisjunctions() {
        for (Clause c : this) {
            if (c.size() <= 1) continue;
            return true;
        }
        return false;
    }

    public Monom extractMonom() {
        if (this.hasDisjunctions()) {
            throw new IllegalArgumentException("Cannot extract a monom from a non-monom CNF");
        }
        Monom m = new Monom();
        for (Clause c : this) {
            m.add(c.iterator().next());
        }
        return m;
    }

    public boolean isObviouslyContradictory() {
        return this.contains(new Clause("A")) && this.contains(new Clause("!A"));
    }

    public boolean entailedBy(Monom m) {
        for (Clause c : this) {
            boolean clauseSatisfied = false;
            for (Literal l : c) {
                if (l.getPropertyName().equals("=")) {
                    if (!LogicUtil.evalEquality(l)) continue;
                    clauseSatisfied = true;
                    break;
                }
                if ((!l.isPositive() || !m.contains(l)) && (!l.isNegated() || m.contains(l.clone().toggleNegation()))) continue;
                clauseSatisfied = true;
                break;
            }
            if (clauseSatisfied) continue;
            return false;
        }
        return true;
    }
}

