/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.logic.fol.structure;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Type
implements Serializable {
    private final String name;
    private final List<Type> superTypeList;
    private final List<Type> subTypeList;
    private final List<Type> subTypeOfBuffer;
    private final List<Type> supTypeOfBuffer;

    Type(String name, Collection<Type> parentTypeList) {
        this(name);
        if (parentTypeList != null) {
            this.superTypeList.addAll(parentTypeList);
            for (Type parentType : parentTypeList) {
                parentType.subTypeList.add(this);
            }
        }
    }

    Type(String name, Type parentType) {
        this(name);
        if (parentType != null) {
            this.superTypeList.add(parentType);
            parentType.subTypeList.add(this);
        }
    }

    public Type(String name) {
        if (name.trim() == "") {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.subTypeList = new LinkedList<Type>();
        this.superTypeList = new LinkedList<Type>();
        this.supTypeOfBuffer = new LinkedList<Type>();
        this.subTypeOfBuffer = new LinkedList<Type>();
    }

    public String getName() {
        return this.name;
    }

    public void addSubType(Type newSubType) {
        if (this.isSubTypeOf(newSubType)) {
            throw new IllegalArgumentException("Cannot add " + newSubType + " as a sub-type of " + this + ", because the relation already exists the other way around.");
        }
        newSubType.superTypeList.add(this);
        this.subTypeList.add(newSubType);
    }

    public void removeSubType(Type removeSubType) {
        removeSubType.superTypeList.remove(this);
        this.subTypeList.remove(removeSubType);
    }

    public List<Type> getDirectSubTypes() {
        return this.subTypeList;
    }

    public List<Type> getAllSubTypes() {
        LinkedList<Type> allSubTypeList = new LinkedList<Type>(this.getDirectSubTypes());
        for (Type subType : this.getDirectSubTypes()) {
            allSubTypeList.addAll(subType.getAllSubTypes());
        }
        return allSubTypeList;
    }

    public List<Type> getAllSubTypesIncl() {
        List<Type> allSubTypeInclList = this.getAllSubTypes();
        allSubTypeInclList.add(this);
        return allSubTypeInclList;
    }

    public void addSuperType(Type newSuperType) {
        if (this.isSuperTypeOf(newSuperType)) {
            throw new IllegalArgumentException("Cannot add " + newSuperType + " as a super-type of " + this + ", because the relation already exists the other way around.");
        }
        newSuperType.subTypeList.add(this);
        this.superTypeList.add(newSuperType);
    }

    public void removeSuperType(Type removeSuperType) {
        removeSuperType.subTypeList.remove(this);
        this.superTypeList.remove(removeSuperType);
    }

    public List<Type> getDirectSuperTypes() {
        return this.superTypeList;
    }

    public boolean isRootType() {
        return this.superTypeList.isEmpty();
    }

    public boolean isSuperTypeOf(Type typeToCheck) {
        if (typeToCheck == null) {
            throw new IllegalArgumentException("Null is not a feasible type for this function");
        }
        if (typeToCheck == this || this.subTypeOfBuffer.indexOf(typeToCheck) >= 0) {
            return true;
        }
        assert (!this.subTypeList.contains(this)) : "Type " + this.getName() + " contains itself as a sub-type!";
        for (Type subType : this.subTypeList) {
            if (!subType.isSuperTypeOf(typeToCheck)) continue;
            this.subTypeOfBuffer.add(typeToCheck);
            return true;
        }
        return false;
    }

    public boolean isSubTypeOf(Type typeToCheck) {
        if (typeToCheck == this || this.supTypeOfBuffer.indexOf(typeToCheck) >= 0) {
            return true;
        }
        if (!this.superTypeList.isEmpty() && typeToCheck.isSuperTypeOf(this)) {
            this.supTypeOfBuffer.add(typeToCheck);
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name + ";");
        for (Type superType : this.superTypeList) {
            sb.append(superType.name);
            if (this.superTypeList.indexOf(superType) >= this.superTypeList.size() - 1) continue;
            sb.append('&');
        }
        return sb.toString();
    }

    public void addSuperType(Set<Type> parentTypeCollection) {
        for (Type superType : parentTypeCollection) {
            this.addSuperType(superType);
        }
    }

    public static Type getGreatestSubType(Type type, Type type2) {
        if (type.isSubTypeOf(type2)) {
            return type;
        }
        if (type2.isSubTypeOf(type)) {
            return type2;
        }
        return null;
    }

    public List<Type> getInheritanceHierarchyIncludingType() {
        LinkedList<Type> inheritanceList = new LinkedList<Type>();
        inheritanceList.add(this);
        for (Type superType : this.superTypeList) {
            inheritanceList.addAll(superType.getInheritanceHierarchyIncludingType());
        }
        return inheritanceList;
    }

    public List<Type> getConcretesHierarchyIncludingType() {
        LinkedList<Type> concretesList = new LinkedList<Type>();
        concretesList.add(this);
        for (Type subType : this.subTypeList) {
            concretesList.addAll(subType.getConcretesHierarchyIncludingType());
        }
        return concretesList;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Type)) {
            return false;
        }
        Type other = (Type)o;
        return this.name.equals(other.name);
    }

    public List<Type> getAllSuperTypes() {
        LinkedList<Type> superTypes = new LinkedList<Type>(this.getDirectSuperTypes());
        for (Type superType : this.getDirectSuperTypes()) {
            superTypes.addAll(superType.getAllSuperTypesIncl());
        }
        return superTypes;
    }

    public List<Type> getAllSuperTypesIncl() {
        LinkedList<Type> superTypes = new LinkedList<Type>(this.getAllSuperTypes());
        superTypes.add(this);
        return superTypes;
    }

    public String serialize() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(";");
        if (!this.isRootType()) {
            for (Type superType : this.getDirectSuperTypes()) {
                sb.append(superType.getName());
                if (this.getDirectSuperTypes().indexOf(superType) >= this.getDirectSuperTypes().size() - 1) continue;
                sb.append("&");
            }
        }
        return sb.toString();
    }
}

