/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.logic.fol.algorithms.resolution;

import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.logic.fol.algorithms.resolution.ResolutionPair;
import ai.libs.jaicore.logic.fol.algorithms.resolution.ResolutionStep;
import ai.libs.jaicore.logic.fol.algorithms.resolution.ResolutionTree;
import ai.libs.jaicore.logic.fol.structure.CNFFormula;
import ai.libs.jaicore.logic.fol.structure.Clause;
import ai.libs.jaicore.logic.fol.structure.ConstantParam;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.LiteralParam;
import ai.libs.jaicore.logic.fol.structure.VariableParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Solver {
    private static final Logger logger = LoggerFactory.getLogger(Solver.class);
    private final Set<CNFFormula> formulas = new HashSet<CNFFormula>();
    private final Map<CNFFormula, CNFFormula> internalRepresentationOfFormulas = new HashMap<CNFFormula, CNFFormula>();
    private ResolutionTree tree;
    private int varCounter = 1;

    public Set<CNFFormula> getFormulas() {
        return this.formulas;
    }

    public Map<CNFFormula, CNFFormula> getInternalRepresentationOfFormulas() {
        return this.internalRepresentationOfFormulas;
    }

    public void addFormula(CNFFormula formula) {
        this.formulas.add(formula);
        CNFFormula disAmbFormula = new CNFFormula();
        for (Clause c : formula) {
            Set<VariableParam> paramsInC = c.getVariableParams();
            HashMap<VariableParam, VariableParam> substitution = new HashMap<VariableParam, VariableParam>();
            for (VariableParam p : paramsInC) {
                substitution.put(p, new VariableParam("c" + this.varCounter + "_" + p.getName()));
            }
            disAmbFormula.add(new Clause(c, (Map<VariableParam, ? extends LiteralParam>)substitution));
            ++this.varCounter;
        }
        this.internalRepresentationOfFormulas.put(formula, disAmbFormula);
    }

    public void removeFormula(CNFFormula formula) {
        this.formulas.remove(formula);
        this.internalRepresentationOfFormulas.remove(formula);
    }

    public boolean isSatisfiable(CNFFormula formula) throws InterruptedException {
        CNFFormula internalRepresentation = this.internalRepresentationOfFormulas.get(formula);
        CNFFormula resultOfResolution = this.performResolutionUntilEmptyClauseIsFound(internalRepresentation, internalRepresentation);
        this.internalRepresentationOfFormulas.put(formula, resultOfResolution);
        return !resultOfResolution.contains(new HashSet());
    }

    public boolean isSatisfiable(CNFFormula formula, CNFFormula formulaToChooseAtLeastOneLiteralFrom) throws InterruptedException {
        CNFFormula internalRepresentationOfFormula1 = this.internalRepresentationOfFormulas.get(formula);
        CNFFormula internalRepresentationOfFormula2 = this.internalRepresentationOfFormulas.get(formulaToChooseAtLeastOneLiteralFrom);
        CNFFormula joint = new CNFFormula();
        joint.addAll(internalRepresentationOfFormula1);
        joint.addAll(internalRepresentationOfFormula2);
        CNFFormula resultOfResolution = this.performResolutionUntilEmptyClauseIsFound(joint, internalRepresentationOfFormula2);
        return !resultOfResolution.contains(new HashSet());
    }

    public boolean isSatisfiable() throws InterruptedException {
        CNFFormula jointFormula = new CNFFormula();
        for (CNFFormula formula : this.formulas) {
            jointFormula.addAll(this.internalRepresentationOfFormulas.get(formula));
        }
        CNFFormula resultOfResolution = this.performResolutionUntilEmptyClauseIsFound(jointFormula, jointFormula);
        return !resultOfResolution.contains(new HashSet());
    }

    protected CNFFormula performResolutionUntilEmptyClauseIsFound(CNFFormula formula, CNFFormula formulaToChooseAtLeastOneLiteralFrom) throws InterruptedException {
        ResolutionPair nextPair;
        HashSet<ResolutionPair> candidates = new HashSet<ResolutionPair>();
        candidates.addAll(this.getPossibleResolutionPairs(formulaToChooseAtLeastOneLiteralFrom));
        for (Clause c : formula) {
            candidates.addAll(this.getPossibleResolutionPairs(formulaToChooseAtLeastOneLiteralFrom, c));
        }
        this.tree = new ResolutionTree(formula);
        CNFFormula currentFormula = new CNFFormula(formula);
        logger.info("Starting resolution for formula {} using in each iteration literals from {}", (Object)formula, (Object)formulaToChooseAtLeastOneLiteralFrom);
        logger.info("The initial set of candidates is {}", candidates);
        while ((nextPair = this.getNextPair(candidates)) != null) {
            ResolutionStep step = this.performResolutionStepForPair(nextPair);
            if (step == null) continue;
            Clause resolvent = step.getR();
            logger.debug("Size is {}: Resolving {} with {} on literal {} with unifier {}. Resolvent is: {}", new Object[]{candidates.size(), nextPair.getC1(), nextPair.getC2(), nextPair.getL1().getProperty(), step.getUnificator(), resolvent});
            if (nextPair.getC1().isTautological() || nextPair.getC2().isTautological()) {
                System.err.println("Resolved tautological clause!");
                System.exit(1);
            }
            if (resolvent.isEmpty()) {
                logger.debug("Found empty clause, canceling process.");
                currentFormula.add(resolvent);
                this.tree.addResolutionStep(step);
                return currentFormula;
            }
            if (this.isClauseAlreadyContainedInFormula(currentFormula, resolvent)) {
                logger.debug("Ignoring resolvent, because it is already contained in the known formula.");
                continue;
            }
            this.tree.addResolutionStep(step);
            if (resolvent.isTautological()) {
                logger.debug("Not considering any clauses producible with this resolvent, because it is tautological.");
                continue;
            }
            logger.debug("Added resolvent {} to formula, which has now size {}.", (Object)resolvent, (Object)currentFormula.size());
            currentFormula.add(resolvent);
            List<ResolutionPair> successors = this.getPossibleResolutionPairs(currentFormula, resolvent);
            candidates.addAll(this.getAdmissiblePairs(successors));
        }
        return currentFormula;
    }

    public ResolutionTree getTree() {
        return this.tree;
    }

    protected ResolutionPair getNextPair(Set<ResolutionPair> candidates) {
        List pairsWithUnitClause = candidates.stream().filter(p -> p.getC1().size() == 1 || p.getC2().size() == 1).collect(Collectors.toList());
        if (!pairsWithUnitClause.isEmpty()) {
            ResolutionPair pair = (ResolutionPair)pairsWithUnitClause.get(0);
            candidates.remove(pair);
            return pair;
        }
        Optional min = candidates.stream().min((p1, p2) -> p1.getC1().size() + p1.getC2().size() - (p2.getC1().size() + p2.getC2().size()));
        if (!min.isPresent()) {
            return null;
        }
        ResolutionPair pair = (ResolutionPair)min.get();
        candidates.remove(pair);
        return pair;
    }

    protected List<ResolutionPair> getPossibleResolutionPairs(CNFFormula formula) throws InterruptedException {
        LinkedList<ResolutionPair> pairs = new LinkedList<ResolutionPair>();
        Set candidates = SetUtil.getAllPossibleSubsetsWithSize((Collection)formula, (int)2).stream().map(c -> new LinkedList(c)).collect(Collectors.toSet());
        for (List pair : candidates) {
            Clause c1 = (Clause)pair.get(0);
            Clause c2 = (Clause)pair.get(1);
            boolean invert = c1.size() > c2.size();
            pairs.addAll(this.getPossibleResolutionsPairsOfClauses(invert ? c2 : c1, invert ? c1 : c2));
        }
        return pairs;
    }

    protected abstract List<ResolutionPair> getAdmissiblePairs(List<ResolutionPair> var1);

    protected List<ResolutionPair> getPossibleResolutionPairs(CNFFormula formula, Clause c2) {
        logger.debug("Computing all resolution pairs between formula {} and clause {}", (Object)formula, (Object)c2);
        LinkedList<ResolutionPair> pairs = new LinkedList<ResolutionPair>();
        for (Clause c1 : formula) {
            boolean invert = c1.size() > c2.size();
            pairs.addAll(this.getPossibleResolutionsPairsOfClauses(invert ? c2 : c1, invert ? c1 : c2));
        }
        return pairs;
    }

    protected Set<Clause> getClausesWithSamePredicates(CNFFormula formula, Clause c2) {
        HashSet<Clause> clausesWithSamePredicates = new HashSet<Clause>();
        Set<String> predicatesInC2 = c2.toPropositionalSet();
        for (Clause c1 : formula) {
            if (c1.size() != c2.size() || !c1.toPropositionalSet().equals(predicatesInC2)) continue;
            clausesWithSamePredicates.add(c1);
        }
        return clausesWithSamePredicates;
    }

    protected boolean isClauseAlreadyContainedInFormula(CNFFormula formula, Clause c) throws InterruptedException {
        if (formula.contains(c)) {
            return true;
        }
        Set<Clause> possibleMatchings = this.getClausesWithSamePredicates(formula, c);
        int numberOfVarsInC = c.getVariableParams().size();
        for (Clause candidate : possibleMatchings) {
            Set<VariableParam> paramsOfCandidate = candidate.getVariableParams();
            Clause clauseWithLessParams = numberOfVarsInC < paramsOfCandidate.size() ? c : candidate;
            Clause clauseWithMoreParams = clauseWithLessParams == c ? candidate : c;
            for (Map map : SetUtil.allTotalMappings(clauseWithMoreParams.getVariableParams(), clauseWithLessParams.getVariableParams())) {
                Clause clauseWithMoreParamsMapped = new Clause(clauseWithMoreParams, map);
                if (!clauseWithMoreParamsMapped.equals(clauseWithLessParams)) continue;
                return true;
            }
        }
        return false;
    }

    protected List<ResolutionPair> getPossibleResolutionsPairsOfClauses(Clause c1, Clause c2) {
        ArrayList<ResolutionPair> pairs = new ArrayList<ResolutionPair>();
        if (c1.size() > c2.size()) {
            System.err.println("Error, first clause bigger than second!");
        }
        for (Literal l1 : c1) {
            for (Literal l2 : c2) {
                if (!l1.getPropertyName().equals(l2.getPropertyName()) || l1.isPositive() == l2.isPositive()) continue;
                pairs.add(new ResolutionPair(c1, c2, l1, l2));
            }
        }
        logger.debug("Possible resolution pairs for clauses {} and {} are {}", new Object[]{c1, c2, pairs});
        return pairs;
    }

    protected ResolutionStep performResolutionStepForPair(ResolutionPair pair) {
        Map<VariableParam, LiteralParam> unifier = this.getUnificatorForLiterals(pair.getL1(), pair.getL2());
        if (unifier == null) {
            return null;
        }
        Clause basicResolvent = new Clause();
        for (Object l : pair.getC1()) {
            if (l == pair.getL1()) continue;
            basicResolvent.add(new Literal((Literal)l, unifier));
        }
        for (Object l : pair.getC2()) {
            if (l == pair.getL2()) continue;
            basicResolvent.add(new Literal((Literal)l, unifier));
        }
        HashMap<VariableParam, VariableParam> substitution = new HashMap<VariableParam, VariableParam>();
        for (VariableParam var : basicResolvent.getVariableParams()) {
            substitution.put(var, new VariableParam("_" + var.getName()));
        }
        Clause resolvent = new Clause(basicResolvent, (Map<VariableParam, ? extends LiteralParam>)substitution);
        return new ResolutionStep(pair, resolvent, unifier);
    }

    protected Map<VariableParam, LiteralParam> getUnificatorForLiterals(Literal l1, Literal l2) {
        LinkedList<LiteralParam> p1 = new LinkedList<LiteralParam>(l1.getParameters());
        LinkedList<LiteralParam> p2 = new LinkedList<LiteralParam>(l2.getParameters());
        if (p1.size() != p2.size()) {
            return null;
        }
        HashMap<VariableParam, LiteralParam> unifier = new HashMap<VariableParam, LiteralParam>();
        for (int i = 0; i < p1.size(); ++i) {
            LiteralParam v1 = (LiteralParam)p1.get(i);
            LiteralParam v2 = (LiteralParam)p2.get(i);
            if (v1 instanceof ConstantParam && v2 instanceof ConstantParam && !v1.equals(v2)) {
                return null;
            }
            if (v1 instanceof VariableParam && v2 instanceof ConstantParam) {
                unifier.put((VariableParam)v1, v2);
                for (VariableParam key : unifier.keySet()) {
                    if (!((LiteralParam)unifier.get(key)).equals(v1)) continue;
                    unifier.put(key, v2);
                }
                continue;
            }
            if (v2 instanceof VariableParam && v1 instanceof ConstantParam) {
                unifier.put((VariableParam)v2, v1);
                for (VariableParam key : unifier.keySet()) {
                    if (!((LiteralParam)unifier.get(key)).equals(v2)) continue;
                    unifier.put(key, v1);
                }
                continue;
            }
            if (!v1.equals(v2)) {
                unifier.put((VariableParam)v2, v1);
            }
            for (VariableParam key : unifier.keySet()) {
                if (!((LiteralParam)unifier.get(key)).equals(v2)) continue;
                unifier.put(key, v1);
            }
        }
        return unifier;
    }
}

