/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.logic.fol.util;

import ai.libs.jaicore.logic.fol.structure.ConstantParam;
import ai.libs.jaicore.logic.fol.structure.InterpretedLiteral;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.LiteralParam;
import ai.libs.jaicore.logic.fol.structure.LiteralSet;
import ai.libs.jaicore.logic.fol.structure.VariableParam;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LiteralStringParser {
    private static Pattern basicPattern = Pattern.compile("(!|~)?(.*)\\(([^\\)]*)\\)");

    public static LiteralSet convertStringToLiteralSetWithConst(String literalSetString, Set<String> evaluablePredicates) {
        LiteralSet literalSet = new LiteralSet();
        String[] literals = literalSetString.split("&");
        if (literals.length != 1 || !literals[0].isEmpty()) {
            for (int i = 0; i < literals.length; ++i) {
                literalSet.add(LiteralStringParser.convertStringToLiteralWithConst(literals[i], evaluablePredicates));
            }
        }
        return literalSet;
    }

    public static Literal convertStringToLiteralWithConst(String literalString, Set<String> evaluablePredicates) {
        String string = literalString.replace(" ", "");
        Matcher matcher = basicPattern.matcher(string = string.trim());
        if (!matcher.find()) {
            return null;
        }
        MatchResult results = matcher.toMatchResult();
        String predicateName = results.group(2);
        String[] paramsAsStrings = results.group(3).split(",");
        LinkedList<LiteralParam> params = new LinkedList<LiteralParam>();
        for (int i = 0; i < paramsAsStrings.length; ++i) {
            String param = paramsAsStrings[i].trim();
            params.add(param.startsWith("'") ? new ConstantParam(param.replace("'", "")) : new VariableParam(param));
        }
        if (evaluablePredicates.contains(predicateName)) {
            return new InterpretedLiteral(predicateName, (List<LiteralParam>)params, results.group(1) == null);
        }
        return new Literal(predicateName, params, results.group(1) == null);
    }
}

