/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.logic.fol.algorithms.resolution;

import ai.libs.jaicore.logic.fol.algorithms.resolution.ResolutionPair;
import ai.libs.jaicore.logic.fol.algorithms.resolution.ResolutionStep;
import ai.libs.jaicore.logic.fol.structure.Clause;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ResolutionTree {
    private Set<Clause> baseClauses;
    private Set<ResolutionPair> resolvedPairs = new HashSet<ResolutionPair>();
    private Map<Clause, ResolutionStep> resolventsWithTheirSteps = new HashMap<Clause, ResolutionStep>();

    public ResolutionTree(Set<Clause> baseClauses) {
        this.baseClauses = baseClauses;
    }

    public void addResolutionStep(ResolutionStep step) {
        this.resolventsWithTheirSteps.put(step.getR(), step);
        this.resolvedPairs.add(step.getPair());
    }

    public Set<Clause> getBaseClauses() {
        return this.baseClauses;
    }

    public Map<Clause, ResolutionStep> getResolventsWithTheirSteps() {
        return this.resolventsWithTheirSteps;
    }

    public boolean isClausePairAdmissible(ResolutionPair pair) {
        if (this.resolvedPairs.contains(pair)) {
            return false;
        }
        Clause c1 = pair.getC1();
        Clause c2 = pair.getC2();
        if (this.baseClauses.contains(c1) && this.baseClauses.contains(c2)) {
            return false;
        }
        Set<Clause> parentsOfC1 = this.getAllClausesUsedToObtainResolvent(c1);
        if (parentsOfC1.contains(c2)) {
            return false;
        }
        Set<Clause> parentsOfC2 = this.getAllClausesUsedToObtainResolvent(c2);
        return !parentsOfC2.contains(c1);
    }

    public Set<Clause> getAllClausesUsedToObtainResolvent(Clause resolvent) {
        HashSet<Clause> clauses = new HashSet<Clause>();
        for (ResolutionStep step : this.getAllStepsUsedToObtainResolvent(resolvent)) {
            clauses.add(step.getPair().getC1());
            clauses.add(step.getPair().getC2());
        }
        return clauses;
    }

    public boolean containsResolvent(Clause resolvent) {
        return this.baseClauses.contains(resolvent) || this.resolventsWithTheirSteps.containsKey(resolvent);
    }

    public boolean containsEmptyClause() {
        return this.containsResolvent(new Clause());
    }

    public Set<ResolutionStep> getAllStepsUsedToObtainResolvent(Clause resolvent) {
        if (this.baseClauses.contains(resolvent)) {
            return new HashSet<ResolutionStep>();
        }
        HashSet<ResolutionStep> steps = new HashSet<ResolutionStep>();
        ResolutionStep step = this.resolventsWithTheirSteps.get(resolvent);
        steps.add(step);
        steps.addAll(this.getAllStepsUsedToObtainResolvent(step.getPair().getC1()));
        steps.addAll(this.getAllStepsUsedToObtainResolvent(step.getPair().getC2()));
        return steps;
    }

    public void printAsGraphViz(String filename) {
        StringBuilder str = new StringBuilder();
        str.append("digraph {\n");
        for (Clause c : this.baseClauses) {
            str.append("\"" + c.toString() + "\"\n");
        }
        for (Clause resolvent : this.resolventsWithTheirSteps.keySet()) {
            ResolutionPair pair = this.resolventsWithTheirSteps.get(resolvent).getPair();
            str.append("\"" + pair.getC1().toString() + "\" -> \"" + resolvent.toString() + "\"\n");
            str.append("\"" + pair.getC2().toString() + "\" -> \"" + resolvent.toString() + "\"\n");
        }
        str.append("}");
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(filename, new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(str.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

