/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.logic.fol.structure;

import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.LiteralParam;
import ai.libs.jaicore.logic.fol.structure.VariableParam;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpretedLiteral
extends Literal {
    private static final Logger logger = LoggerFactory.getLogger(InterpretedLiteral.class);

    public InterpretedLiteral(Literal l, Map<VariableParam, ? extends LiteralParam> map) {
        super(l, map);
    }

    public InterpretedLiteral(String property, LiteralParam parameter) {
        super(property, parameter);
    }

    public InterpretedLiteral(String property, List<LiteralParam> parameters) {
        super(property, parameters);
    }

    public InterpretedLiteral(String property) {
        super(property);
    }

    public InterpretedLiteral(String predicateName, List<LiteralParam> params, boolean b) {
        super(predicateName, params, b);
    }

    @Override
    public Literal clone() {
        return new InterpretedLiteral(this.getProperty(), this.getParameters());
    }

    @Override
    public Literal clone(Map<? extends VariableParam, ? extends LiteralParam> mapping) {
        logger.debug("start cloning");
        InterpretedLiteral clone = new InterpretedLiteral(this.getProperty());
        for (LiteralParam v : this.getParameters()) {
            if (v instanceof VariableParam) {
                if (mapping != null && mapping.containsKey(v)) {
                    logger.trace("Params: {}", clone.parameters);
                }
                clone.parameters.add(mapping != null && mapping.containsKey(v) ? mapping.get(v) : v);
                continue;
            }
            clone.parameters.add(v);
        }
        logger.debug("finished cloning");
        return clone;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("i*");
        sb.append(super.toString());
        return sb.toString();
    }
}

