/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.logic.fol.structure;

import ai.libs.jaicore.basic.StringUtil;
import ai.libs.jaicore.logic.fol.structure.ConstantParam;
import ai.libs.jaicore.logic.fol.structure.LiteralParam;
import ai.libs.jaicore.logic.fol.structure.VariableParam;
import ai.libs.jaicore.logic.fol.util.LogicUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Literal
implements Serializable {
    private static Logger logger = LoggerFactory.getLogger(Literal.class);
    private String property;
    private List<LiteralParam> parameters = new ArrayList<LiteralParam>();

    public Literal(Literal l, Map<? extends LiteralParam, ? extends LiteralParam> map) {
        this(l.getProperty());
        for (LiteralParam p : l.getParameters()) {
            this.parameters.add(map.containsKey(p) ? map.get(p) : p);
        }
    }

    public Literal(String property, LiteralParam parameter) {
        this(property);
        this.parameters.add(parameter);
    }

    public Literal(String property, List<? extends LiteralParam> parameters) {
        this(property);
        this.parameters.addAll(parameters);
    }

    public Literal(String pPropertyWithParams) {
        if (pPropertyWithParams.contains("=")) {
            String[] params = StringUtil.explode((String)pPropertyWithParams, (String)"=");
            boolean isNegated = params.length > 0 && params[0].endsWith("!");
            String string = this.property = isNegated ? "!=" : "=";
            if (params.length == 2) {
                int p1Length = isNegated ? params[0].length() - 1 : params[0].length();
                this.parameters.add(LogicUtil.parseParamName(params[0].substring(0, p1Length).trim()));
                this.parameters.add(LogicUtil.parseParamName(params[1].trim()));
            }
        } else {
            boolean isPositive = true;
            String propertyWithParams = "" + pPropertyWithParams;
            if (pPropertyWithParams.startsWith("!")) {
                isPositive = false;
                propertyWithParams = pPropertyWithParams.substring(1);
            }
            if (propertyWithParams.contains("(")) {
                if (propertyWithParams.contains(")")) {
                    int index = propertyWithParams.indexOf(40);
                    this.property = propertyWithParams.substring(0, index);
                    if (index < propertyWithParams.length() - 2) {
                        this.parameters.addAll(Arrays.asList(StringUtil.explode((String)propertyWithParams.substring(index + 1, propertyWithParams.length() - 1), (String)",")).stream().map(s -> LogicUtil.parseParamName(s.trim())).collect(Collectors.toList()));
                    }
                }
            } else {
                this.property = propertyWithParams;
            }
            if (!isPositive) {
                this.property = "!" + this.property;
            }
        }
        if (this.property == null) {
            throw new IllegalArgumentException("Given string \"" + pPropertyWithParams + "\" causes a NULL property!");
        }
    }

    public Literal(String property2, boolean isPositive) {
        this(property2);
        if (isPositive && this.isNegated() || !isPositive && this.isPositive()) {
            this.toggleNegation();
        }
    }

    public Literal(String property2, List<? extends LiteralParam> parameters, boolean isPositive) {
        this(property2, parameters);
        if (isPositive && this.isNegated() || !isPositive && this.isPositive()) {
            this.toggleNegation();
        }
    }

    public final String getProperty() {
        return (this.isNegated() ? "!" : "") + this.getPropertyName();
    }

    public final String getPropertyName() {
        return this.isNegated() ? this.property.substring(1) : this.property;
    }

    public final List<LiteralParam> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public final boolean isNegated() {
        return this.property.startsWith("!");
    }

    public Literal toggleNegation() {
        this.property = this.isNegated() ? this.getPropertyName() : "!" + this.getPropertyName();
        return this;
    }

    public final List<VariableParam> getVariableParams() {
        LinkedList<VariableParam> vars = new LinkedList<VariableParam>();
        for (LiteralParam param : this.parameters) {
            if (!(param instanceof VariableParam)) continue;
            vars.add((VariableParam)param);
        }
        return Collections.unmodifiableList(vars);
    }

    public final List<ConstantParam> getConstantParams() {
        ArrayList<ConstantParam> constants = new ArrayList<ConstantParam>();
        for (LiteralParam param : this.parameters) {
            if (!(param instanceof ConstantParam)) continue;
            constants.add((ConstantParam)param);
        }
        return Collections.unmodifiableList(constants);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.property == null ? 0 : this.property.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Literal other = (Literal)obj;
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        return !(this.property == null ? other.property != null : !this.property.equals(other.property));
    }

    public Literal clone() {
        return new Literal(this.property, this.parameters);
    }

    public Literal clone(Map<? extends VariableParam, ? extends LiteralParam> mapping) {
        logger.debug("start cloning");
        Literal clone = new Literal(this.property);
        for (LiteralParam v : this.getParameters()) {
            if (v instanceof VariableParam && mapping != null && mapping.containsKey(v)) {
                logger.trace("Params: {}", clone.parameters);
                if (mapping.get(v) == null) {
                    throw new IllegalArgumentException("Mapping " + mapping + " assigns null to a parameter, which must not be the case!");
                }
                clone.parameters.add(mapping.get(v));
                continue;
            }
            clone.parameters.add(v);
        }
        logger.debug("finished cloning");
        return clone;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean printTypesOfParams) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.property + "(");
        int params = this.parameters.size();
        int i = 1;
        for (LiteralParam p : this.parameters) {
            sb.append(printTypesOfParams ? p.toString() : p.getName());
            if (i++ >= params) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean isNegationOf(Literal l) {
        return l.getPropertyName().equals(this.getPropertyName()) && l.getParameters().equals(this.parameters) && l.isNegated() != this.isNegated();
    }

    public boolean isPositive() {
        return !this.isNegated();
    }

    public boolean hasVariableParams() {
        return !this.getVariableParams().isEmpty();
    }

    public final boolean isGround() {
        return !this.hasVariableParams();
    }
}

