/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.logic.fol.algorithms.resolution;

import ai.libs.jaicore.logic.fol.algorithms.resolution.Solver;
import ai.libs.jaicore.logic.fol.algorithms.resolution.UnitResolutionSolver;
import ai.libs.jaicore.logic.fol.structure.CNFFormula;
import ai.libs.jaicore.logic.fol.structure.Clause;
import java.util.stream.Collectors;

public class SolverFactory {
    private static SolverFactory singleton = new SolverFactory();

    private SolverFactory() {
    }

    public static SolverFactory getInstance() {
        return singleton;
    }

    public Solver getSolver(CNFFormula formula) {
        boolean isHorn = true;
        for (Clause c : formula) {
            if (c.stream().filter(l -> l.isPositive()).limit(2L).collect(Collectors.toList()).size() <= 1) continue;
            isHorn = false;
            break;
        }
        if (isHorn) {
            UnitResolutionSolver solver = new UnitResolutionSolver();
            solver.addFormula(formula);
            return solver;
        }
        throw new IllegalArgumentException("Formula " + formula + " is not in HORN!");
    }
}

