/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.logic.fol.structure;

import ai.libs.jaicore.logic.fol.structure.Clause;
import ai.libs.jaicore.logic.fol.structure.ConstantParam;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.LiteralParam;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.logic.fol.structure.VariableParam;
import ai.libs.jaicore.logic.fol.util.LogicUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DNFFormula
extends HashSet<Monom> {
    public DNFFormula() {
    }

    public DNFFormula(Monom m) {
        this.add(m);
    }

    public DNFFormula(Clause m) {
        for (Literal l : m) {
            this.add(new Monom(l));
        }
    }

    public DNFFormula(Collection<Monom> m) {
        this.addAll(m);
    }

    public DNFFormula(Set<Monom> monoms, Map<VariableParam, ? extends LiteralParam> mapping) {
        for (Monom c : monoms) {
            Monom replacedMonom = new Monom((Collection<Literal>)c, mapping);
            if (replacedMonom.isEmpty()) {
                this.clear();
                this.add(new Monom("A"));
                this.add(new Monom("!A"));
                return;
            }
            if (replacedMonom.isContradictory()) continue;
            this.add(replacedMonom);
        }
    }

    public Set<VariableParam> getVariableParams() {
        HashSet<VariableParam> vars = new HashSet<VariableParam>();
        for (Monom m : this) {
            vars.addAll(m.getVariableParams());
        }
        return vars;
    }

    public Set<ConstantParam> getConstantParams() {
        HashSet<ConstantParam> constants = new HashSet<ConstantParam>();
        for (Monom m : this) {
            constants.addAll(m.getConstantParams());
        }
        return constants;
    }

    public boolean hasConjunctions() {
        for (Monom m : this) {
            if (m.size() <= 1) continue;
            return true;
        }
        return false;
    }

    public Clause extractClause() {
        if (this.hasConjunctions()) {
            throw new IllegalArgumentException("Cannot extract a clause from a non-monom DNF");
        }
        Clause c = new Clause();
        for (Monom m : this) {
            c.add((Literal)m.iterator().next());
        }
        return c;
    }

    public boolean entailedBy(Monom m) {
        for (Monom m2 : this) {
            boolean monomSatisfied = true;
            for (Literal l : m2) {
                if (l.getPropertyName().equals("=")) {
                    if (LogicUtil.evalEquality(l)) continue;
                    monomSatisfied = false;
                    break;
                }
                if (l.isPositive() && m.contains(l) || l.isNegated() && !m.contains(l.clone().toggleNegation())) continue;
                monomSatisfied = false;
                break;
            }
            if (!monomSatisfied) continue;
            return true;
        }
        return false;
    }
}

