/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.logic.fol.structure;

import ai.libs.jaicore.basic.StringUtil;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.logic.fol.structure.ConstantParam;
import ai.libs.jaicore.logic.fol.structure.InterpretedLiteral;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.LiteralParam;
import ai.libs.jaicore.logic.fol.structure.VariableParam;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteralSet
extends HashSet<Literal> {
    private static final long serialVersionUID = 6767454041686262363L;
    private static Logger logger = LoggerFactory.getLogger(LiteralSet.class);

    public LiteralSet() {
    }

    public LiteralSet(String literals, String delimiter) {
        this(Arrays.asList(StringUtil.explode((String)literals, (String)delimiter)).stream().map(s -> new Literal(s.trim())).collect(Collectors.toList()));
    }

    public LiteralSet(Literal literal) {
        this.add(literal.clone());
    }

    public LiteralSet(Collection<Literal> literals, boolean deep) {
        if (literals != null) {
            if (deep) {
                for (Literal l : literals) {
                    this.add(l.clone());
                }
            } else {
                this.addAll(literals);
            }
        }
    }

    public LiteralSet(Collection<Literal> literals) {
        this(literals, true);
    }

    public LiteralSet(Collection<Literal> literals, Map<? extends LiteralParam, ? extends LiteralParam> mapping) {
        logger.debug("init with: {}", literals);
        for (Literal l : literals) {
            logger.debug("call clone for literal {}, which is of class {}, on literal set {}", new Object[]{l, l.getClass(), this});
            this.add(new Literal(l, mapping));
            logger.debug("finished clone for literal {}, which is of class {}, on literal set {}", new Object[]{l, l.getClass(), this});
        }
    }

    @Override
    public boolean add(String literalDescriptor) {
        return this.add(new Literal(literalDescriptor));
    }

    public boolean implies(LiteralSet conclusion) throws InterruptedException {
        if (this.containsAll(conclusion)) {
            return true;
        }
        for (Map mapping : SetUtil.allMappings(this.getVariableParams(), conclusion.getVariableParams(), (boolean)false, (boolean)false, (boolean)false)) {
            if (!new LiteralSet((Collection<Literal>)this, mapping).containsAll(conclusion)) continue;
            return true;
        }
        return false;
    }

    public boolean isConsistent() {
        for (Literal l : this) {
            String prop = l.getProperty();
            String negProp = prop.startsWith("!") ? prop.substring(1) : "!" + prop;
            if (!this.contains(new Literal(negProp, l.getParameters()))) continue;
            return false;
        }
        return true;
    }

    public Map<VariableParam, VariableParam> getImplyingMappingThatMapsFromConclusionVarsToPremiseVars(LiteralSet conclusion) throws InterruptedException {
        for (Map mapping : SetUtil.allMappings(conclusion.getVariableParams(), this.getVariableParams(), (boolean)false, (boolean)false, (boolean)false)) {
            if (!this.containsAll(new LiteralSet((Collection<Literal>)conclusion, mapping))) continue;
            return mapping;
        }
        return null;
    }

    public LiteralSet getPositiveLiterals() {
        LiteralSet ls = new LiteralSet();
        for (Literal l : this) {
            if (!l.isPositive()) continue;
            ls.add(l);
        }
        return ls;
    }

    public LiteralSet getNegativeLiterals() {
        LiteralSet ls = new LiteralSet();
        for (Literal l : this) {
            if (!l.isNegated()) continue;
            ls.add(l);
        }
        return ls;
    }

    public Set<LiteralParam> getParameters() {
        HashSet<LiteralParam> params = new HashSet<LiteralParam>();
        for (Literal literal : this) {
            params.addAll(literal.getParameters());
        }
        return params;
    }

    public Set<VariableParam> getVariableParams() {
        HashSet<VariableParam> vars = new HashSet<VariableParam>();
        for (Literal literal : this) {
            vars.addAll(literal.getVariableParams());
        }
        return vars;
    }

    public Set<ConstantParam> getConstantParams() {
        HashSet<ConstantParam> constants = new HashSet<ConstantParam>();
        for (Literal literal : this) {
            constants.addAll(literal.getConstantParams());
        }
        return constants;
    }

    public Set<InterpretedLiteral> getInterpretedLiterals() {
        HashSet<InterpretedLiteral> interpretedLiteralSet = new HashSet<InterpretedLiteral>();
        for (Literal l : this) {
            if (!(l instanceof InterpretedLiteral)) continue;
            interpretedLiteralSet.add((InterpretedLiteral)l);
        }
        return interpretedLiteralSet;
    }

    public Set<String> toPropositionalSet() {
        HashSet<String> propositionalSet = new HashSet<String>();
        for (Literal l : this) {
            propositionalSet.add(l.getProperty());
        }
        return propositionalSet;
    }

    public boolean containsPositiveAndNegativeVersionOfLiteral() {
        for (Literal l1 : this) {
            for (Literal l2 : this) {
                if (!l1.isNegationOf(l2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsGroundEqualityPredicateThatEvaluatesTo(boolean eval) {
        for (Literal l : this) {
            if (!l.getPropertyName().equals("=") || !l.isGround()) continue;
            List<ConstantParam> params = l.getConstantParams();
            if (l.isPositive() == params.get(0).equals(params.get(1)) != eval) continue;
            return true;
        }
        return false;
    }

    public boolean containsLiteralWithPredicatename(String predicateName) {
        for (Literal l : this) {
            if (!l.getPropertyName().equals(predicateName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasVariables() {
        return !this.getVariableParams().isEmpty();
    }

    public Set<Literal> getLiteralsWithPropertyName(String propertyName) {
        HashSet<Literal> literalsWithPropertyName = new HashSet<Literal>();
        for (Literal lit : this) {
            if (!lit.getPropertyName().equals(propertyName)) continue;
            literalsWithPropertyName.add(lit);
        }
        return literalsWithPropertyName;
    }
}

