/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.logic.fol.structure;

import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.LiteralParam;
import ai.libs.jaicore.logic.fol.structure.LiteralSet;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.logic.fol.structure.VariableParam;
import ai.libs.jaicore.logic.fol.util.LogicUtil;
import java.util.Map;

public class Clause
extends LiteralSet {
    private static final long serialVersionUID = 3915423297171319761L;

    public static Clause getByNegatingMonom(Monom m) {
        Clause c = new Clause();
        for (Literal l : m) {
            c.add(new Literal(l.getProperty(), l.getParameters(), !l.isPositive()));
        }
        return c;
    }

    public Clause() {
    }

    public Clause(Literal l) {
        super(l);
    }

    public Clause(LiteralSet literals, Map<VariableParam, ? extends LiteralParam> m) {
        for (Literal l : literals) {
            Literal lCopy = l.clone(m);
            if (lCopy.getPropertyName().equals("=") && lCopy.isGround()) {
                if (!LogicUtil.evalEquality(lCopy)) continue;
                this.clear();
                this.add(new Literal("A"));
                this.add(new Literal("!A"));
                return;
            }
            this.add(lCopy);
        }
    }

    public Clause(String literals) {
        super(literals, "\\|");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean firstElement = true;
        for (Literal l : this) {
            if (firstElement) {
                firstElement = false;
            } else {
                sb.append("|");
            }
            sb.append(l);
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean isTautological() {
        return this.containsPositiveAndNegativeVersionOfLiteral();
    }
}

