/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.logic.fol.util;

import ai.libs.jaicore.basic.algorithm.AAlgorithm;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.LiteralParam;
import ai.libs.jaicore.logic.fol.structure.LiteralSet;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.logic.fol.structure.VariableParam;
import ai.libs.jaicore.logic.fol.util.ForwardChainerRecursionEvent;
import ai.libs.jaicore.logic.fol.util.ForwardChainingFailedCWABindingEvent;
import ai.libs.jaicore.logic.fol.util.ForwardChainingProblem;
import ai.libs.jaicore.logic.fol.util.NextBindingFoundEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.api4.java.algorithm.IAlgorithm;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardChainer
extends AAlgorithm<ForwardChainingProblem, Collection<Map<VariableParam, LiteralParam>>> {
    private Logger logger = LoggerFactory.getLogger(ForwardChainer.class);
    private Monom conclusion;
    private Monom cwaRelevantNegativeLiterals;
    private Monom factbase;
    private Literal chosenLiteral;
    private List<Map<VariableParam, LiteralParam>> possibleChoicesForLocalLiteral;
    private Monom remainingConclusion;
    private Map<VariableParam, LiteralParam> currentGroundingOfLocalLiteral;
    private Monom currentGroundRemainingConclusion;
    private ForwardChainer currentlyActiveSubFC;

    public ForwardChainer(ForwardChainingProblem problem) {
        super((Object)problem);
        if (problem.getConclusion().isEmpty()) {
            throw new IllegalArgumentException("Ill-defined forward chaining problem with empty conclusion!");
        }
    }

    public IAlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException {
        long start = System.currentTimeMillis();
        switch (this.getState()) {
            case CREATED: {
                this.conclusion = ((ForwardChainingProblem)this.getInput()).getConclusion();
                assert (!this.conclusion.isEmpty()) : "The algorithm should not be invoked with an empty conclusion";
                this.factbase = ((ForwardChainingProblem)this.getInput()).getFactbase();
                this.logger.info("Computing substitution for {}-conclusion that enable forward chaining from factbase of size {}. Enable trace for more detailed output.", (Object)this.conclusion.size(), (Object)this.factbase.size());
                this.logger.trace("Conclusion is {}", (Object)this.conclusion);
                this.logger.trace("Factbase is {}", (Object)this.factbase);
                if (((ForwardChainingProblem)this.getInput()).isCwa()) {
                    Monom positiveLiterals = new Monom();
                    Monom negativeLiterals = new Monom();
                    for (Object l : this.conclusion) {
                        if (((Literal)l).isPositive()) {
                            positiveLiterals.add(l);
                            continue;
                        }
                        negativeLiterals.add(l);
                    }
                    this.conclusion = positiveLiterals;
                    this.cwaRelevantNegativeLiterals = negativeLiterals;
                }
                int currentlyFewestOptions = Integer.MAX_VALUE;
                long timeToPrepareCWAVersion = System.currentTimeMillis();
                for (Literal nextLitealCandidate : this.conclusion) {
                    this.checkAndConductTermination();
                    this.logger.debug("Considering {} as next literal for grounding.", (Object)nextLitealCandidate);
                    long candidateGroundingStart = System.currentTimeMillis();
                    List<Map<VariableParam, LiteralParam>> choicesTmp = this.getGroundingsUnderWhichALiteralAppearsInFactBase(this.factbase, nextLitealCandidate, currentlyFewestOptions);
                    this.logger.debug("Computation of {} groundings took {}ms.", (Object)choicesTmp.size(), (Object)(System.currentTimeMillis() - candidateGroundingStart));
                    if (choicesTmp.size() >= currentlyFewestOptions) continue;
                    this.chosenLiteral = nextLitealCandidate;
                    this.possibleChoicesForLocalLiteral = choicesTmp;
                    currentlyFewestOptions = choicesTmp.size();
                    if (currentlyFewestOptions != 0) continue;
                    break;
                }
                assert (this.chosenLiteral != null) : "No literal has been chosen";
                assert (this.possibleChoicesForLocalLiteral != null) : "List of possible choices for literal must not be null";
                this.remainingConclusion = new Monom();
                for (Literal l : this.conclusion) {
                    if (l.equals(this.chosenLiteral)) continue;
                    this.remainingConclusion.add(l);
                }
                long end = System.currentTimeMillis();
                this.logger.debug("Selected literal {} with still unbound params {} that can be ground in {} ways in {}ms.", new Object[]{this.chosenLiteral, this.chosenLiteral.getVariableParams(), this.possibleChoicesForLocalLiteral.size(), end - timeToPrepareCWAVersion});
                this.logger.info("Initialized FC algorithm within {}ms.", (Object)(end - start));
                return this.activate();
            }
            case ACTIVE: {
                this.checkAndConductTermination();
                if (this.currentlyActiveSubFC != null) {
                    this.logger.trace("Reuse currently active recursive FC as it may still have solutions ...");
                    NextBindingFoundEvent event = this.currentlyActiveSubFC.nextBinding();
                    if (event == null) {
                        this.currentlyActiveSubFC = null;
                    } else {
                        Map<VariableParam, LiteralParam> subsolution = event.getGrounding();
                        this.logger.debug("Identified recursively determined sub-solution {}", subsolution);
                        HashMap<VariableParam, LiteralParam> solutionToReturn = new HashMap<VariableParam, LiteralParam>(subsolution);
                        solutionToReturn.putAll(this.currentGroundingOfLocalLiteral);
                        assert (this.verifyThatGroundingEnablesConclusion(this.factbase, this.currentGroundRemainingConclusion, solutionToReturn));
                        if (((ForwardChainingProblem)this.getInput()).isCwa() && this.doesCWADeductionFail(this.factbase, new LiteralSet((Collection<Literal>)this.cwaRelevantNegativeLiterals, solutionToReturn))) {
                            return new ForwardChainingFailedCWABindingEvent((IAlgorithm<?, ?>)this);
                        }
                        this.logger.info("Computed binding {} for {}-conclusion within {}ms", new Object[]{solutionToReturn, this.conclusion.size(), System.currentTimeMillis() - start});
                        return new NextBindingFoundEvent((IAlgorithm<?, ?>)this, (Map<VariableParam, LiteralParam>)solutionToReturn);
                    }
                }
                this.logger.debug("Determine a new out of {} remaining groundings for {} to be analyzed.", (Object)this.possibleChoicesForLocalLiteral.size(), (Object)this.chosenLiteral);
                boolean foundAChoiceThatMightBeFeasible = false;
                while (!foundAChoiceThatMightBeFeasible && !this.possibleChoicesForLocalLiteral.isEmpty()) {
                    this.checkAndConductTermination();
                    this.currentGroundingOfLocalLiteral = this.possibleChoicesForLocalLiteral.get(0);
                    this.possibleChoicesForLocalLiteral.remove(0);
                    this.logger.debug("Considering choice {}", this.currentGroundingOfLocalLiteral);
                    Monom modifiedRemainingConclusion = new Monom((Collection<Literal>)this.remainingConclusion, this.currentGroundingOfLocalLiteral);
                    this.logger.trace("Checking whether one of the ground remaining conclusion {} is not in the state.", (Object)modifiedRemainingConclusion);
                    if (this.doesConclusionContainAGroundLiteralThatIsNotInFactBase(this.factbase, modifiedRemainingConclusion)) continue;
                    foundAChoiceThatMightBeFeasible = true;
                    this.currentGroundRemainingConclusion = modifiedRemainingConclusion;
                    break;
                }
                this.logger.debug("Selected grounding {}. {} possible other groundings remain.", this.currentGroundingOfLocalLiteral, (Object)this.possibleChoicesForLocalLiteral.size());
                if (!foundAChoiceThatMightBeFeasible) {
                    assert (this.possibleChoicesForLocalLiteral.isEmpty()) : "Collection of possible choices should be empty when no grounding was chosen!";
                    this.logger.debug("Finishing process for {}-conclusion since no (more) grounding is avilable for predicate {}.", (Object)this.conclusion.size(), (Object)this.chosenLiteral);
                    return this.terminate();
                }
                if (this.currentGroundRemainingConclusion.isEmpty()) {
                    return new NextBindingFoundEvent((IAlgorithm<?, ?>)this, this.currentGroundingOfLocalLiteral);
                }
                this.logger.debug("Recurse to {}-conclusion", (Object)this.currentGroundRemainingConclusion.size());
                ForwardChainingProblem subProblem = new ForwardChainingProblem(this.factbase, this.currentGroundRemainingConclusion, ((ForwardChainingProblem)this.getInput()).isCwa());
                long startRecursiveCall = System.currentTimeMillis();
                this.logger.debug("Finished recursion of {}-conclusion. Computation took {}ms", (Object)this.currentGroundRemainingConclusion.size(), (Object)(System.currentTimeMillis() - startRecursiveCall));
                this.currentlyActiveSubFC = new ForwardChainer(subProblem);
                return new ForwardChainerRecursionEvent((IAlgorithm<?, ?>)this, this.chosenLiteral, this.currentGroundRemainingConclusion);
            }
        }
        throw new IllegalStateException("Don't know how to behave in state " + this.getState());
    }

    public Collection<Map<VariableParam, LiteralParam>> call() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException {
        NextBindingFoundEvent e;
        ArrayList<Map<VariableParam, LiteralParam>> mappings = new ArrayList<Map<VariableParam, LiteralParam>>();
        while ((e = this.nextBinding()) != null) {
            this.logger.info("Adding solution grounding {} to output set.", e.getGrounding());
            mappings.add(e.getGrounding());
        }
        return mappings;
    }

    public NextBindingFoundEvent nextBinding() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException {
        while (this.hasNext()) {
            IAlgorithmEvent e = this.nextWithException();
            if (!(e instanceof NextBindingFoundEvent)) continue;
            return (NextBindingFoundEvent)e;
        }
        return null;
    }

    public Collection<Map<VariableParam, LiteralParam>> getSubstitutionsThatEnableForwardChaining(Collection<Literal> factbase, Collection<Literal> conclusion) {
        return this.getSubstitutionsThatEnableForwardChaining(factbase, new ArrayList<Literal>(conclusion));
    }

    public boolean doesConclusionContainAGroundLiteralThatIsNotInFactBase(Collection<Literal> factbase, Collection<Literal> conclusion) {
        for (Literal l : conclusion) {
            if (!l.isGround() || factbase.contains(l)) continue;
            return true;
        }
        return false;
    }

    public boolean doesCWADeductionFail(Collection<Literal> factbase, Collection<Literal> conclusion) {
        for (Literal l : conclusion) {
            if (!l.isGround() || !(l.isPositive() ? !factbase.contains(l) : factbase.contains(l.clone().toggleNegation()))) continue;
            return true;
        }
        return false;
    }

    public List<Map<VariableParam, LiteralParam>> getGroundingsUnderWhichALiteralAppearsInFactBase(Collection<Literal> factbase, Literal l, int maxSubstitutions) {
        List<VariableParam> openParams = l.getVariableParams();
        this.logger.debug("Compute possible sub-groundings of the open parameters.");
        long start = System.currentTimeMillis();
        ArrayList<Map<VariableParam, LiteralParam>> choices = new ArrayList<Map<VariableParam, LiteralParam>>();
        if (openParams.isEmpty()) {
            choices.add(new HashMap());
        } else {
            for (Literal fact : factbase) {
                if (!fact.getPropertyName().equals(l.getPropertyName()) || fact.isPositive() != l.isPositive()) continue;
                this.logger.trace("Considering known literal {} as a literal that can be used for grounding", (Object)fact);
                List<LiteralParam> factParams = fact.getParameters();
                List<LiteralParam> nextLiteralParams = l.getParameters();
                HashMap<VariableParam, LiteralParam> submap = new HashMap<VariableParam, LiteralParam>();
                boolean paramsCanBeMatched = true;
                for (int i = 0; i < factParams.size(); ++i) {
                    if (nextLiteralParams.get(i) instanceof VariableParam) {
                        submap.put((VariableParam)nextLiteralParams.get(i), factParams.get(i));
                        continue;
                    }
                    if (nextLiteralParams.get(i).equals(factParams.get(i))) continue;
                    paramsCanBeMatched = false;
                    break;
                }
                if (!paramsCanBeMatched) continue;
                this.logger.trace("Adding {} as a possible such grounding.", submap);
                choices.add(submap);
                if (choices.size() < maxSubstitutions) continue;
                this.logger.debug("Reached maximum number {} of required substitutions. Returning what we have so far.", (Object)maxSubstitutions);
                return choices;
            }
        }
        this.logger.debug("Done. Computation of {} groundings took {}ms", (Object)choices.size(), (Object)(System.currentTimeMillis() - start));
        return choices;
    }

    public boolean verifyThatGroundingEnablesConclusion(Collection<Literal> factbase, Collection<Literal> conclusion, Map<VariableParam, LiteralParam> grounding) {
        for (Literal l : conclusion) {
            Literal lg = new Literal(l, grounding);
            if (factbase.contains(lg) == l.isPositive()) continue;
            this.logger.error("Literal {} in conclusion ground to {} does not follow from state: ", (Object)l, (Object)lg);
            factbase.stream().sorted((l1, l2) -> l1.toString().compareTo(l2.toString())).forEach(lit -> this.logger.info("\t{}", lit));
            return false;
        }
        return true;
    }
}

