/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.logic.fol.util;

import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.LiteralParam;
import ai.libs.jaicore.logic.fol.structure.TypeModule;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeUtil.class);
    public static final String GODFATHER_TYPE = "Thing";
    private static TypeModule typeMod;

    private TypeUtil() {
    }

    public static void setTypeModule(TypeModule typeModule) {
        typeMod = typeModule;
    }

    public static void defineGodfatherDataTypes(Literal l) {
        TypeUtil.checkTypeModule();
        for (LiteralParam p : l.getParameters()) {
            if (p.getType() != null) continue;
            p.setType(typeMod.getType(GODFATHER_TYPE));
        }
    }

    public static void defineGodfatherDataTypes(Set<? extends Literal> m) {
        for (Literal literal : m) {
            TypeUtil.defineGodfatherDataTypes(literal);
        }
    }

    public static void defineGodfatherDataTypes(List<? extends Literal> m) {
        for (Literal literal : m) {
            TypeUtil.defineGodfatherDataTypes(literal);
        }
    }

    private static void checkTypeModule() {
        if (typeMod == null) {
            typeMod = new TypeModule();
            LOGGER.warn("TypeModule in DataTypeUtil has not been set. Now, operating on own TypeModule");
        }
    }
}

