/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.logic.fol.structure;

import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.logging.ToJSONStringUtil;
import ai.libs.jaicore.logic.fol.structure.CNFFormula;
import ai.libs.jaicore.logic.fol.structure.Clause;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.LiteralParam;
import ai.libs.jaicore.logic.fol.structure.LiteralSet;
import ai.libs.jaicore.logic.fol.structure.VariableParam;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Monom
extends LiteralSet {
    private static final long serialVersionUID = 1279300062766067057L;

    public static Monom fromCNFFormula(CNFFormula formula) {
        Monom m = new Monom();
        for (Clause c : formula) {
            if (c.size() > 1) {
                throw new IllegalArgumentException("Monom constructor says: Cannot create monom from CNF with disjunctions " + formula);
            }
            m.addAll(c);
        }
        return m;
    }

    public Monom() {
    }

    public Monom(Literal l) {
        super(l);
    }

    public Monom(String literals) {
        super(literals, "&");
    }

    public Monom(Collection<Literal> set) {
        this(set, true);
    }

    public Monom(Collection<Literal> set, boolean deep) {
        super(set, deep);
    }

    public Monom(Collection<Literal> literals, Map<? extends LiteralParam, ? extends LiteralParam> mapping) {
        super(literals, mapping);
    }

    @Override
    public String toString() {
        HashMap<String, Monom> fields = new HashMap<String, Monom>();
        fields.put("literals", this);
        return ToJSONStringUtil.toJSONString((String)this.getClass().getSimpleName(), fields);
    }

    public boolean isContradictory() {
        return this.containsPositiveAndNegativeVersionOfLiteral() || this.containsGroundEqualityPredicateThatEvaluatesTo(false);
    }

    @Override
    public boolean isConsistent() {
        return !this.isContradictory();
    }

    @Override
    public boolean implies(LiteralSet conclusion) throws InterruptedException {
        for (Map mapping : SetUtil.allMappings(this.getVariableParams(), conclusion.getVariableParams(), (boolean)false, (boolean)false, (boolean)false)) {
            if (!new LiteralSet((Collection<Literal>)this, mapping).containsAll(conclusion)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<VariableParam, VariableParam> getImplyingMappingThatMapsFromConclusionVarsToPremiseVars(LiteralSet conclusion) throws InterruptedException {
        for (Map mapping : SetUtil.allMappings(conclusion.getVariableParams(), this.getVariableParams(), (boolean)false, (boolean)false, (boolean)false)) {
            if (!this.containsAll(new LiteralSet((Collection<Literal>)conclusion, mapping))) continue;
            return mapping;
        }
        return null;
    }

    public CNFFormula asCNF() {
        CNFFormula formula = new CNFFormula();
        for (Literal l : this) {
            formula.add(new Clause(l));
        }
        return formula;
    }
}

