/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.logic.fol.structure;

import ai.libs.jaicore.logic.fol.structure.ConstantParam;
import ai.libs.jaicore.logic.fol.structure.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TypeModule {
    private final Map<String, Type> typeMap = new HashMap<String, Type>();
    private final Map<String, ConstantParam> constants = new HashMap<String, ConstantParam>();

    public TypeModule() {
    }

    public TypeModule(Collection<Type> types) {
        for (Type type : types) {
            this.typeMap.put(type.getName(), type);
        }
    }

    public Type getType(String nameOfType) {
        if (nameOfType.trim().isEmpty()) {
            throw new IllegalArgumentException("Empty string is no valid name for a datatype.");
        }
        return this.typeMap.computeIfAbsent(nameOfType, Type::new);
    }

    public int size() {
        return this.typeMap.size();
    }

    public Collection<Type> getAllTypes() {
        return this.typeMap.values();
    }

    public List<Type> getListOfAllTypes() {
        LinkedList<Type> result = new LinkedList<Type>();
        result.addAll(this.typeMap.values());
        return result;
    }

    public void merge(TypeModule typeModule) {
        for (Type otherType : typeModule.getAllTypes()) {
            this.getType(otherType.getName());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Type type : this.typeMap.values()) {
            sb.append(type);
            sb.append("\n");
        }
        return sb.toString();
    }

    public void setConstantType(String constant, Type type) {
        this.constants.put(constant, new ConstantParam(constant, type));
    }

    public Type getConstantType(String constant) {
        if (!this.constants.containsKey(constant)) {
            throw new IllegalArgumentException("Constant " + constant + " not found!");
        }
        return this.constants.get(constant).getType();
    }

    public Collection<ConstantParam> getConstants() {
        return this.constants.values();
    }
}

