/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.math.linearalgebra;

import ai.libs.jaicore.math.linearalgebra.Vector;

public abstract class AbstractVector
implements Vector {
    @Override
    public void squareRoot() {
        for (int i = 0; i < this.length(); ++i) {
            this.setValue(i, Math.sqrt(this.getValue(i)));
        }
    }

    @Override
    public Vector squareRootToCopy() {
        Vector copy = this.duplicate();
        for (int i = 0; i < this.length(); ++i) {
            copy.setValue(i, Math.sqrt(this.getValue(i)));
        }
        return copy;
    }

    @Override
    public void incrementValueAt(int index, double amount) {
        this.setValue(index, amount + this.getValue(index));
    }

    @Override
    public double sum() {
        double sum = 0.0;
        for (int i = 0; i < this.length(); ++i) {
            sum += this.getValue(i);
        }
        return sum;
    }

    @Override
    public double mean() {
        return this.sum() / (double)this.length();
    }

    @Override
    public double standardDeviation() {
        double mean = this.mean();
        double std = 0.0;
        for (int i = 0; i < this.length(); ++i) {
            std += Math.pow(mean - this.getValue(i), 2.0);
        }
        return Math.sqrt(std /= (double)this.length());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        sb.append(this.getValue(0));
        for (int i = 1; i < this.length(); ++i) {
            sb.append(",").append(this.getValue(i));
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void zeroAllDimensions() {
        for (int i = 0; i < this.length(); ++i) {
            this.setValue(i, 0.0);
        }
    }

    @Override
    public double euclideanNorm() {
        return Math.sqrt(this.dotProduct(this));
    }

    @Override
    public Vector addVectorToCopy(double[] vectorAsArray) {
        Vector vector = this.duplicate();
        vector.addVector(vectorAsArray);
        return vector;
    }

    @Override
    public Vector subtractVectorFromCopy(double[] vectorAsArray) {
        Vector vector = this.duplicate();
        vector.subtractVector(vectorAsArray);
        return vector;
    }

    @Override
    public Vector multiplyByVectorPairwiseToCopy(double[] vectorAsArray) {
        Vector vector = this.duplicate();
        vector.multiplyByVectorPairwise(vectorAsArray);
        return vector;
    }

    @Override
    public Vector divideByVectorPairwiseToCopy(double[] vectorAsArray) {
        Vector vector = this.duplicate();
        vector.divideByVectorPairwise(vectorAsArray);
        return vector;
    }

    @Override
    public Vector addConstantToCopy(double constant) {
        Vector vector = this.duplicate();
        vector.addConstant(constant);
        return vector;
    }

    @Override
    public Vector addVectorToCopy(Vector vector) {
        Vector vectorCopy = this.duplicate();
        vectorCopy.addVector(vector);
        return vectorCopy;
    }

    @Override
    public Vector subtractConstantFromCopy(double constant) {
        Vector vectorCopy = this.duplicate();
        vectorCopy.subtractConstant(constant);
        return vectorCopy;
    }

    @Override
    public Vector subtractVectorFromCopy(Vector vector) {
        Vector vectorCopy = this.duplicate();
        vectorCopy.subtractVector(vector);
        return vectorCopy;
    }

    @Override
    public Vector multiplyByVectorPairwiseToCopy(Vector vector) {
        Vector vectorCopy = this.duplicate();
        vectorCopy.multiplyByVectorPairwise(vector);
        return vectorCopy;
    }

    @Override
    public Vector multiplyByConstantToCopy(double constant) {
        Vector vectorCopy = this.duplicate();
        vectorCopy.multiplyByConstant(constant);
        return vectorCopy;
    }

    @Override
    public Vector divideByVectorPairwiseToCopy(Vector vector) {
        Vector vectorCopy = this.duplicate();
        vectorCopy.divideByVectorPairwise(vector);
        return vectorCopy;
    }

    @Override
    public Vector divideByConstantToCopy(double constant) {
        Vector vectorCopy = this.duplicate();
        vectorCopy.divideByConstant(constant);
        return vectorCopy;
    }

    @Override
    public Double average() {
        double basisAverage = 0.0;
        for (int i = 0; i < this.length(); ++i) {
            basisAverage += this.getValue(i);
        }
        return basisAverage /= (double)this.length();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractVector) {
            AbstractVector vector = (AbstractVector)obj;
            for (int i = 0; i < vector.length(); ++i) {
                if (!(Math.abs(vector.getValue(i) - this.getValue(i)) > 1.0E-17)) continue;
                return false;
            }
            return true;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.length(); ++i) {
            hashCode = 31 * hashCode + Double.valueOf(this.getValue(i)).hashCode();
        }
        return hashCode;
    }
}

