/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.math.linearalgebra;

import ai.libs.jaicore.math.linearalgebra.AbstractVector;
import ai.libs.jaicore.math.linearalgebra.SparseDoubleVector;
import ai.libs.jaicore.math.linearalgebra.Vector;
import ai.libs.jaicore.math.random.RandomGenerator;
import java.util.Arrays;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Vector;

public class DenseDoubleVector
extends AbstractVector {
    private no.uib.cipr.matrix.Vector internalVector;

    public DenseDoubleVector(int numberOfDimensions) {
        this.internalVector = new DenseVector(numberOfDimensions);
    }

    public DenseDoubleVector(double[] data) {
        this.internalVector = new DenseVector(Arrays.copyOf(data, data.length));
    }

    public DenseDoubleVector(no.uib.cipr.matrix.Vector vector) {
        this.internalVector = vector;
    }

    public DenseDoubleVector(int size, double value) {
        this.internalVector = new DenseVector(size);
        for (int index = 0; index < this.internalVector.size(); ++index) {
            this.internalVector.set(index, value);
        }
    }

    @Override
    public int length() {
        return this.internalVector.size();
    }

    @Override
    public double getValue(int index) {
        return this.internalVector.get(index);
    }

    @Override
    public void setValue(int index, double value) {
        this.internalVector.set(index, value);
    }

    @Override
    public void addConstant(double constant) {
        double[] contantAsVector = new double[this.internalVector.size()];
        for (int i = 0; i < contantAsVector.length; ++i) {
            contantAsVector[i] = constant;
        }
        this.addVector(contantAsVector);
    }

    @Override
    public void addVector(Vector vector) {
        this.internalVector = this.internalVector.add(vector.toDenseVector().internalVector);
    }

    @Override
    public void subtractConstant(double constant) {
        this.addConstant(-1.0 * constant);
    }

    @Override
    public void subtractVector(Vector vector) {
        this.internalVector = this.internalVector.add(-1.0, vector.toDenseVector().internalVector);
    }

    @Override
    public void multiplyByVectorPairwise(Vector secondVector) {
        for (int i = 0; i < this.internalVector.size(); ++i) {
            this.internalVector.set(i, this.internalVector.get(i) * secondVector.getValue(i));
        }
    }

    @Override
    public void multiplyByConstant(double constant) {
        this.internalVector = this.internalVector.scale(constant);
    }

    @Override
    public void divideByVectorPairwise(Vector secondVector) {
        for (int i = 0; i < this.internalVector.size(); ++i) {
            this.internalVector.set(i, this.internalVector.get(i) / secondVector.getValue(i));
        }
    }

    @Override
    public void divideByConstant(double constant) {
        this.internalVector = this.internalVector.scale(1.0 / constant);
    }

    @Override
    public double dotProduct(Vector vector) {
        return this.internalVector.dot(vector.toDenseVector().internalVector);
    }

    @Override
    public boolean isSparse() {
        return false;
    }

    @Override
    public double[] asArray() {
        double[] result = new double[this.internalVector.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.internalVector.get(i);
        }
        return result;
    }

    @Override
    public void addVector(double[] vectorAsArray) {
        this.addVector(new DenseDoubleVector(vectorAsArray));
    }

    @Override
    public void subtractVector(double[] vectorAsArray) {
        this.subtractVector(new DenseDoubleVector(vectorAsArray));
    }

    @Override
    public void multiplyByVectorPairwise(double[] vectorAsArray) {
        this.multiplyByVectorPairwise(new DenseDoubleVector(vectorAsArray));
    }

    @Override
    public void divideByVectorPairwise(double[] vectorAsArray) {
        this.divideByVectorPairwise(new DenseDoubleVector(vectorAsArray));
    }

    @Override
    public double dotProduct(double[] vectorAsArray) {
        return this.dotProduct(new DenseDoubleVector(vectorAsArray));
    }

    @Override
    public Vector duplicate() {
        return new DenseDoubleVector(this.asArray());
    }

    @Override
    public void normalize() {
        this.internalVector = this.internalVector.scale(1.0 / this.internalVector.norm(Vector.Norm.Two));
    }

    @Override
    public void fillRandomly() {
        for (int numberOfAddedValues = 0; numberOfAddedValues < this.internalVector.size(); ++numberOfAddedValues) {
            double fillValue = RandomGenerator.getRNG().nextDouble();
            this.internalVector.set(numberOfAddedValues, fillValue);
        }
    }

    @Override
    public DenseDoubleVector toDenseVector() {
        return this;
    }

    @Override
    public SparseDoubleVector toSparseVector() {
        return new SparseDoubleVector(this.asArray());
    }
}

