/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.math.linearalgebra;

import ai.libs.jaicore.math.linearalgebra.DenseDoubleVector;
import ai.libs.jaicore.math.linearalgebra.SparseDoubleVector;

public interface Vector {
    public void addVector(double[] var1);

    public Vector addVectorToCopy(double[] var1);

    public void subtractVector(double[] var1);

    public Vector subtractVectorFromCopy(double[] var1);

    public void multiplyByVectorPairwise(double[] var1);

    public Vector multiplyByVectorPairwiseToCopy(double[] var1);

    public void divideByVectorPairwise(double[] var1);

    public Vector divideByVectorPairwiseToCopy(double[] var1);

    public double dotProduct(double[] var1);

    public int length();

    public double getValue(int var1);

    public void setValue(int var1, double var2);

    public void addConstant(double var1);

    public Vector addConstantToCopy(double var1);

    public void addVector(Vector var1);

    public Vector addVectorToCopy(Vector var1);

    public void subtractConstant(double var1);

    public Vector subtractConstantFromCopy(double var1);

    public void subtractVector(Vector var1);

    public Vector subtractVectorFromCopy(Vector var1);

    public void multiplyByVectorPairwise(Vector var1);

    public Vector multiplyByVectorPairwiseToCopy(Vector var1);

    public void multiplyByConstant(double var1);

    public Vector multiplyByConstantToCopy(double var1);

    public void divideByVectorPairwise(Vector var1);

    public Vector divideByVectorPairwiseToCopy(Vector var1);

    public void divideByConstant(double var1);

    public Vector divideByConstantToCopy(double var1);

    public double dotProduct(Vector var1);

    public void squareRoot();

    public Vector squareRootToCopy();

    public boolean isSparse();

    public double[] asArray();

    public DenseDoubleVector toDenseVector();

    public SparseDoubleVector toSparseVector();

    public Vector duplicate();

    public void normalize();

    public void incrementValueAt(int var1, double var2);

    public double sum();

    public double mean();

    public double standardDeviation();

    public void zeroAllDimensions();

    public void fillRandomly();

    public double euclideanNorm();

    public Double average();

    public static Vector merge(Vector v1, Vector v2) {
        int i;
        DenseDoubleVector resultingVector = new DenseDoubleVector(v1.length() + v2.length());
        for (i = 0; i < v1.length(); ++i) {
            resultingVector.setValue(i, v1.getValue(i));
        }
        for (i = 0; i < v2.length(); ++i) {
            resultingVector.setValue(v1.length() + i, v2.getValue(i));
        }
        return resultingVector;
    }
}

