/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.math.linearalgebra;

import ai.libs.jaicore.math.linearalgebra.AbstractVector;
import ai.libs.jaicore.math.linearalgebra.DenseDoubleVector;
import ai.libs.jaicore.math.linearalgebra.Vector;
import ai.libs.jaicore.math.random.RandomGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.SparseVector;

public class SparseDoubleVector
extends AbstractVector {
    protected SparseVector internalVector;
    private boolean isChanged = true;

    public SparseDoubleVector(int[] indices, double[] values, int dimension) {
        this.internalVector = new SparseVector(dimension, indices, values);
        this.setIsChanged();
    }

    public SparseDoubleVector(int dimension) {
        this.internalVector = new SparseVector(dimension);
    }

    public SparseDoubleVector(double[] data) {
        ArrayList<Integer> indicesWithNonZeroEntry = new ArrayList<Integer>();
        ArrayList<Double> nonZeroEntries = new ArrayList<Double>();
        for (int i2 = 0; i2 < data.length; ++i2) {
            if (Double.compare(data[i2], 0.0) == 0) continue;
            indicesWithNonZeroEntry.add(i2);
            nonZeroEntries.add(data[i2]);
        }
        this.internalVector = new SparseVector(data.length, indicesWithNonZeroEntry.stream().mapToInt(i -> i).toArray(), nonZeroEntries.stream().mapToDouble(d -> d).toArray());
        this.setIsChanged();
    }

    public SparseDoubleVector(SparseVector mtjVector) {
        this.internalVector = mtjVector;
        this.setIsChanged();
    }

    @Override
    public void addVector(double[] vectorAsArray) {
        this.setIsChanged();
        this.addVector(new SparseDoubleVector(vectorAsArray));
    }

    @Override
    public void subtractVector(double[] vectorAsArray) {
        this.setIsChanged();
        this.internalVector = (SparseVector)this.internalVector.add(-1.0, (no.uib.cipr.matrix.Vector)new SparseDoubleVector((double[])vectorAsArray).internalVector);
    }

    @Override
    public void multiplyByVectorPairwise(double[] vectorAsArray) {
        this.setIsChanged();
        SparseVector vector = this.internalVector;
        int[] indexes = vector.getIndex();
        for (int i = 0; i < indexes.length; ++i) {
            vector.set(indexes[i], vector.get(indexes[i]) * vectorAsArray[indexes[i]]);
        }
        this.internalVector = vector;
    }

    @Override
    public void divideByVectorPairwise(double[] vectorAsArray) {
        this.setIsChanged();
        SparseVector vector = this.internalVector;
        int[] indexes = vector.getIndex();
        for (int i = 0; i < indexes.length; ++i) {
            vector.set(indexes[i], vector.get(indexes[i]) / vectorAsArray[indexes[i]]);
        }
        this.internalVector = vector;
    }

    @Override
    public double dotProduct(double[] vectorAsArray) {
        return this.internalVector.dot((no.uib.cipr.matrix.Vector)new DenseVector(vectorAsArray));
    }

    @Override
    public int length() {
        return this.internalVector.size();
    }

    @Override
    public double getValue(int index) {
        return this.internalVector.get(index);
    }

    @Override
    public void setValue(int index, double value) {
        this.setIsChanged();
        this.internalVector.set(index, value);
    }

    @Override
    public void addVector(Vector vector) {
        this.setIsChanged();
        this.internalVector = (SparseVector)this.internalVector.add((no.uib.cipr.matrix.Vector)vector.toSparseVector().internalVector);
    }

    @Override
    public void subtractVector(Vector vector) {
        this.setIsChanged();
        this.internalVector = (SparseVector)this.internalVector.add(-1.0, (no.uib.cipr.matrix.Vector)vector.toSparseVector().internalVector);
    }

    @Override
    public void multiplyByVectorPairwise(Vector secondVector) {
        this.setIsChanged();
        SparseVector sparseVector = this.internalVector;
        int[] indexes = sparseVector.getIndex();
        for (int i = 0; i < indexes.length; ++i) {
            sparseVector.set(indexes[i], sparseVector.get(indexes[i]) * secondVector.getValue(indexes[i]));
        }
        this.internalVector = sparseVector;
    }

    @Override
    public void multiplyByConstant(double constant) {
        this.setIsChanged();
        this.internalVector = this.internalVector.scale(constant);
    }

    @Override
    public void divideByVectorPairwise(Vector secondVector) {
        this.setIsChanged();
        SparseVector sparseVector = this.internalVector;
        int[] indexes = sparseVector.getIndex();
        for (int i = 0; i < indexes.length; ++i) {
            sparseVector.set(indexes[i], sparseVector.get(indexes[i]) / secondVector.getValue(indexes[i]));
        }
        this.internalVector = sparseVector;
    }

    @Override
    public void divideByConstant(double constant) {
        this.setIsChanged();
        this.internalVector = this.internalVector.scale(1.0 / constant);
    }

    @Override
    public double dotProduct(Vector vector) {
        return this.internalVector.dot((no.uib.cipr.matrix.Vector)vector.toSparseVector().internalVector);
    }

    @Override
    public boolean isSparse() {
        return true;
    }

    @Override
    public double[] asArray() {
        double[] result = new double[this.internalVector.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.internalVector.get(i);
        }
        return result;
    }

    @Override
    public DenseDoubleVector toDenseVector() {
        return new DenseDoubleVector(this.asArray());
    }

    @Override
    public SparseDoubleVector toSparseVector() {
        return this;
    }

    @Override
    public Vector duplicate() {
        return new SparseDoubleVector(this.asArray());
    }

    @Override
    public void normalize() {
        this.setIsChanged();
        this.internalVector = this.internalVector.scale(this.internalVector.norm(Vector.Norm.Two));
    }

    @Override
    public void addConstant(double constant) {
        this.setIsChanged();
        double[] contantAsVector = new double[this.internalVector.size()];
        for (int i = 0; i < contantAsVector.length; ++i) {
            contantAsVector[i] = constant;
        }
        this.addVector(contantAsVector);
    }

    @Override
    public void subtractConstant(double constant) {
        this.setIsChanged();
        this.addConstant(-1.0 * constant);
    }

    @Override
    public void fillRandomly() {
        this.setIsChanged();
        Random random = RandomGenerator.getRNG();
        int numberToAdd = random.nextInt(this.internalVector.size());
        ArrayList<Integer> unfilledIndexes = new ArrayList<Integer>();
        for (int i = 0; i < this.internalVector.size(); ++i) {
            unfilledIndexes.add(i);
        }
        for (int numberOfAddedValues = 0; numberOfAddedValues < numberToAdd; ++numberOfAddedValues) {
            int randomIndex = random.nextInt(unfilledIndexes.size());
            int toBeFilledIndex = (Integer)unfilledIndexes.get(randomIndex);
            double fillValue = random.nextDouble();
            this.internalVector.set(toBeFilledIndex, fillValue);
            unfilledIndexes.remove(0);
        }
    }

    public int[] getNonZeroIndices() {
        if (this.isChanged) {
            ArrayList<Integer> indicesWithNonZeroEntry = new ArrayList<Integer>(this.length());
            ArrayList<Double> nonZeroEntries = new ArrayList<Double>(this.length());
            for (int i2 = 0; i2 < this.length(); ++i2) {
                double value = this.internalVector.get(i2);
                if (Double.compare(value, 0.0) == 0) continue;
                indicesWithNonZeroEntry.add(i2);
                nonZeroEntries.add(value);
            }
            if (indicesWithNonZeroEntry.size() != this.internalVector.getIndex().length) {
                this.internalVector = new SparseVector(indicesWithNonZeroEntry.size(), indicesWithNonZeroEntry.stream().mapToInt(i -> i).toArray(), nonZeroEntries.stream().mapToDouble(d -> d).toArray());
            }
            this.setUnchanged();
        }
        return this.internalVector.getIndex();
    }

    private void setIsChanged() {
        this.isChanged = true;
    }

    private void setUnchanged() {
        this.isChanged = false;
    }

    @Override
    public Vector kroneckerProduct(double[] vectorAsArray) {
        return new SparseDoubleVector(this.kroneckerProductInternal(vectorAsArray));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.internalVector == null ? 0 : this.internalVector.hashCode());
        result = 31 * result + (this.isChanged ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SparseDoubleVector other = (SparseDoubleVector)obj;
        if (this.isChanged != other.isChanged) {
            return false;
        }
        return Arrays.equals(this.asArray(), other.asArray());
    }
}

