/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.math.bayesianinference;

import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.graph.Graph;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.api4.java.common.control.ILoggingCustomizable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BayesNet
implements ILoggingCustomizable {
    private Logger logger = LoggerFactory.getLogger(BayesNet.class);
    private Map<String, Map<Set<String>, Double>> map = new HashMap<String, Map<Set<String>, Double>>();
    private Graph<String> net = new Graph();

    public void addNode(String name) {
        this.net.addItem((Object)name);
    }

    public void addDependency(String child, String parent) {
        this.net.addEdge((Object)parent, (Object)child);
    }

    public void addProbability(String node, Collection<String> parentsThatAreTrue, double probability) {
        if (!this.net.hasItem((Object)node)) {
            throw new IllegalArgumentException("Cannot add probability for unknown node " + node);
        }
        this.map.computeIfAbsent(node, n -> new HashMap()).put(new HashSet<String>(parentsThatAreTrue), probability);
    }

    public void addProbability(String node, double probability) {
        if (!this.net.getPredecessors((Object)node).isEmpty()) {
            throw new IllegalArgumentException("Cannot define prior on non-root node " + node);
        }
        this.addProbability(node, new HashSet<String>(), probability);
    }

    public boolean isWellDefined() throws InterruptedException {
        for (String node : this.net.getItems()) {
            if (this.isProbabilityTableOfNodeWellDefined(node)) continue;
            return false;
        }
        return true;
    }

    public boolean isProbabilityTableOfNodeWellDefined(String node) throws InterruptedException {
        Set parents = this.net.getPredecessors((Object)node);
        if (parents.isEmpty()) {
            if (!this.map.containsKey(node) || this.map.get(node).size() != 1) {
                this.logger.error("{} has no probability map associated", (Object)node);
                return false;
            }
            double prob = this.map.get(node).get(new HashSet());
            return prob >= 0.0 && prob <= 1.0;
        }
        Collection powerset = SetUtil.powerset((Collection)parents);
        if (!this.map.containsKey(node)) {
            this.logger.error("{} has no probability map associated", (Object)node);
            return false;
        }
        Map<Set<String>, Double> tableOfNode = this.map.get(node);
        for (Collection activeParents : powerset) {
            HashSet activeParentsAsSet = new HashSet(activeParents);
            if (!tableOfNode.containsKey(activeParentsAsSet)) {
                this.logger.error("Entry {} not contained.", (Object)activeParents);
                return false;
            }
            double prob = tableOfNode.get(activeParentsAsSet);
            if (!(prob < 0.0) && !(prob > 1.0)) continue;
            this.logger.error("Invalid probability {}", (Object)prob);
            return false;
        }
        return true;
    }

    public Map<String, Map<Set<String>, Double>> getMap() {
        return this.map;
    }

    public Graph<String> getNet() {
        return this.net;
    }

    public double getProbabilityOfPositiveEvent(String node, Set<String> event) {
        HashSet relevantSubset = new HashSet(SetUtil.intersection(event, (Collection)this.net.getPredecessors((Object)node)));
        return this.map.get(node).get(relevantSubset);
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }
}

