/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.math.bayesianinference;

import ai.libs.jaicore.basic.sets.LDSRelationComputer;
import ai.libs.jaicore.basic.sets.RelationComputationProblem;
import ai.libs.jaicore.logging.LoggerUtil;
import ai.libs.jaicore.math.bayesianinference.DiscreteProbabilityDistribution;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;

public class DiscreteProbabilityDistributionPrinter {
    public String getTable(DiscreteProbabilityDistribution d) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> vars = new ArrayList<String>(d.getVariables());
        for (String var : vars) {
            sb.append(var);
            sb.append(" | ");
        }
        sb.append(" P ");
        int len = sb.length();
        sb.append("\n");
        for (int i = 0; i < len; ++i) {
            sb.append("-");
        }
        sb.append("\n");
        ArrayList<List<Integer>> binaryVector = new ArrayList<List<Integer>>();
        int n = vars.size();
        for (int i = 0; i < n; ++i) {
            binaryVector.add(Arrays.asList(0, 1));
        }
        RelationComputationProblem prob = new RelationComputationProblem(binaryVector);
        try {
            List combos = new LDSRelationComputer(prob).call();
            for (List truthVector : combos) {
                HashSet<String> activeVariables = new HashSet<String>();
                for (int i = 0; i < n; ++i) {
                    int val = (Integer)truthVector.get(i);
                    if (val == 1) {
                        activeVariables.add((String)vars.get(i));
                    }
                    sb.append(val + " | ");
                }
                sb.append(d.getProbabilities().get(activeVariables));
                sb.append("\n");
            }
            return sb.toString();
        }
        catch (AlgorithmExecutionCanceledException | AlgorithmTimeoutedException e) {
            return LoggerUtil.getExceptionInfo((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return LoggerUtil.getExceptionInfo((Throwable)e);
        }
    }
}

