/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.math.bayesianinference;

import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.math.bayesianinference.ABayesianInferenceAlgorithm;
import ai.libs.jaicore.math.bayesianinference.BayesianInferenceProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;

public class EnumerationBasedBayesianInferenceSolver
extends ABayesianInferenceAlgorithm {
    public EnumerationBasedBayesianInferenceSolver(BayesianInferenceProblem input) {
        super(input);
    }

    public IAlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        ArrayList<String> hiddenVariableOrder = new ArrayList<String>(this.hiddenVariables);
        HashMap evidenceAssignment = new HashMap(this.evidence);
        Collection entries = SetUtil.powerset((Collection)this.queryVariables);
        for (Collection positiveQueryVariables : entries) {
            HashMap<String, Boolean> initAssignment = new HashMap<String, Boolean>(evidenceAssignment);
            for (String var : this.queryVariables) {
                initAssignment.put(var, positiveQueryVariables.contains(var));
            }
            double prob = this.sumProbability(hiddenVariableOrder, 0, initAssignment);
            this.getDistribution().addProbability(positiveQueryVariables, prob);
        }
        return null;
    }

    public double sumProbability(List<String> hiddenVariables, int indexOfHiddenVariableToSum, Map<String, Boolean> partialAssignment) {
        Set<String> event = partialAssignment.keySet().stream().filter(partialAssignment::get).collect(Collectors.toSet());
        if (indexOfHiddenVariableToSum == hiddenVariables.size()) {
            double product = 1.0;
            for (String var : this.allModelVariables) {
                double factor = this.net.getProbabilityOfPositiveEvent(var, event);
                if (!event.contains(var)) {
                    factor = 1.0 - factor;
                }
                product *= factor;
            }
            return product;
        }
        String branchVariable = hiddenVariables.get(indexOfHiddenVariableToSum);
        partialAssignment.put(branchVariable, false);
        double sum = 0.0;
        sum += this.sumProbability(hiddenVariables, indexOfHiddenVariableToSum + 1, partialAssignment);
        partialAssignment.put(branchVariable, true);
        return sum += this.sumProbability(hiddenVariables, indexOfHiddenVariableToSum + 1, partialAssignment);
    }
}

