/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.math.linearalgebra;

import ai.libs.jaicore.math.linearalgebra.AbstractVector;
import ai.libs.jaicore.math.linearalgebra.SparseDoubleVector;
import ai.libs.jaicore.math.random.RandomGenerator;
import java.util.Arrays;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Vector;
import org.api4.java.common.math.IVector;

public class DenseDoubleVector
extends AbstractVector {
    private Vector internalVector;

    public DenseDoubleVector(int numberOfDimensions) {
        this.internalVector = new DenseVector(numberOfDimensions);
    }

    public DenseDoubleVector(double[] data) {
        this.internalVector = new DenseVector(Arrays.copyOf(data, data.length));
    }

    public DenseDoubleVector(Vector vector) {
        this.internalVector = vector;
    }

    public DenseDoubleVector(int size, double value) {
        this.internalVector = new DenseVector(size);
        for (int index = 0; index < this.internalVector.size(); ++index) {
            this.internalVector.set(index, value);
        }
    }

    public int length() {
        return this.internalVector.size();
    }

    public double getValue(int index) {
        return this.internalVector.get(index);
    }

    public void setValue(int index, double value) {
        this.internalVector.set(index, value);
    }

    public void addConstant(double constant) {
        double[] contantAsVector = new double[this.internalVector.size()];
        for (int i = 0; i < contantAsVector.length; ++i) {
            contantAsVector[i] = constant;
        }
        this.addVector(contantAsVector);
    }

    public void addVector(IVector vector) {
        if (!(vector instanceof AbstractVector)) {
            throw new UnsupportedOperationException("Not implemented for non-AbstractVector vectors.");
        }
        this.internalVector = this.internalVector.add(((AbstractVector)vector).toDenseVector().internalVector);
    }

    public void subtractConstant(double constant) {
        this.addConstant(-1.0 * constant);
    }

    public void subtractVector(IVector vector) {
        this.internalVector = this.internalVector.add(-1.0, ((AbstractVector)vector).toDenseVector().internalVector);
    }

    public void multiplyByVectorPairwise(IVector secondVector) {
        for (int i = 0; i < this.internalVector.size(); ++i) {
            this.internalVector.set(i, this.internalVector.get(i) * secondVector.getValue(i));
        }
    }

    public void multiplyByConstant(double constant) {
        this.internalVector = this.internalVector.scale(constant);
    }

    public void divideByVectorPairwise(IVector secondVector) {
        for (int i = 0; i < this.internalVector.size(); ++i) {
            this.internalVector.set(i, this.internalVector.get(i) / secondVector.getValue(i));
        }
    }

    public void divideByConstant(double constant) {
        this.internalVector = this.internalVector.scale(1.0 / constant);
    }

    public double dotProduct(IVector vector) {
        return this.internalVector.dot(((AbstractVector)vector).toDenseVector().internalVector);
    }

    public boolean isSparse() {
        return false;
    }

    public double[] asArray() {
        double[] result = new double[this.internalVector.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.internalVector.get(i);
        }
        return result;
    }

    public void addVector(double[] vectorAsArray) {
        this.addVector(new DenseDoubleVector(vectorAsArray));
    }

    public void subtractVector(double[] vectorAsArray) {
        this.subtractVector(new DenseDoubleVector(vectorAsArray));
    }

    public void multiplyByVectorPairwise(double[] vectorAsArray) {
        this.multiplyByVectorPairwise(new DenseDoubleVector(vectorAsArray));
    }

    public void divideByVectorPairwise(double[] vectorAsArray) {
        this.divideByVectorPairwise(new DenseDoubleVector(vectorAsArray));
    }

    public double dotProduct(double[] vectorAsArray) {
        return this.dotProduct(new DenseDoubleVector(vectorAsArray));
    }

    public IVector duplicate() {
        return new DenseDoubleVector(this.asArray());
    }

    public void normalize() {
        this.internalVector = this.internalVector.scale(1.0 / this.internalVector.norm(Vector.Norm.Two));
    }

    public void fillRandomly() {
        for (int numberOfAddedValues = 0; numberOfAddedValues < this.internalVector.size(); ++numberOfAddedValues) {
            double fillValue = RandomGenerator.getRNG().nextDouble();
            this.internalVector.set(numberOfAddedValues, fillValue);
        }
    }

    @Override
    public DenseDoubleVector toDenseVector() {
        return this;
    }

    @Override
    public SparseDoubleVector toSparseVector() {
        return new SparseDoubleVector(this.asArray());
    }

    public IVector kroneckerProduct(double[] vectorAsArray) {
        return new DenseDoubleVector(this.kroneckerProductInternal(vectorAsArray));
    }
}

