/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.math.probability.pl;

import ai.libs.jaicore.basic.IOwnerBasedAlgorithmConfig;
import ai.libs.jaicore.basic.algorithm.AAlgorithm;
import ai.libs.jaicore.math.probability.pl.PLInferenceProblem;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.List;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;

public class PLMMAlgorithm
extends AAlgorithm<PLInferenceProblem, DoubleList> {
    private final List<ShortList> rankings;
    private final int numRankings = ((PLInferenceProblem)this.getInput()).getRankings().size();
    private final int numObjects = ((PLInferenceProblem)this.getInput()).getNumObjects();
    private final IntList winVector;
    private DoubleList skillVector;

    public PLMMAlgorithm(PLInferenceProblem input) {
        this(input, null, null);
    }

    public PLMMAlgorithm(PLInferenceProblem input, IOwnerBasedAlgorithmConfig config) {
        this(input, null, config);
    }

    public PLMMAlgorithm(PLInferenceProblem input, DoubleList skillVector, IOwnerBasedAlgorithmConfig config) {
        super(config, (Object)input);
        if (this.numObjects < 2) {
            throw new IllegalArgumentException("Cannot create PL-Algorithm for choice problems with only one option.");
        }
        this.rankings = input.getRankings();
        for (ShortList ranking : this.rankings) {
            if (ranking.size() == this.numObjects) continue;
            throw new UnsupportedOperationException("This MM implementation only supports full rankings!");
        }
        this.skillVector = skillVector != null ? skillVector : PLMMAlgorithm.getDefaultSkillVector(this.numObjects);
        this.winVector = this.getWinVector();
    }

    public static DoubleList getDefaultSkillVector(int n) {
        DoubleArrayList skillVector = new DoubleArrayList();
        double p = 1.0 / (double)n;
        for (int i = 0; i < n; ++i) {
            skillVector.add(p);
        }
        return skillVector;
    }

    public IAlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        DoubleList lastSkillVector = null;
        double epsilon = 1.0E-5;
        double diffToLast = 0.0;
        do {
            this.skillVector = this.normalizeSkillVector(this.getUpdatedSkillVectorImproved(this.skillVector));
            if (lastSkillVector != null) {
                diffToLast = 0.0;
                for (int i = 0; i < this.numObjects; ++i) {
                    diffToLast += Math.abs(this.skillVector.getDouble(i) - lastSkillVector.getDouble(i));
                }
            } else {
                diffToLast = Double.MAX_VALUE;
            }
            lastSkillVector = this.skillVector;
        } while (diffToLast > epsilon);
        return null;
    }

    private DoubleList normalizeSkillVector(DoubleList skillVector) {
        double sum = 0.0;
        DoubleListIterator doubleListIterator = skillVector.iterator();
        while (doubleListIterator.hasNext()) {
            double d = (Double)doubleListIterator.next();
            if (Double.isNaN(d)) {
                throw new IllegalArgumentException("Skill vector has NaN entry: " + skillVector);
            }
            sum += d;
        }
        if (sum < 0.0) {
            sum *= -1.0;
        }
        if (sum == 0.0) {
            throw new IllegalArgumentException("Cannot normalize null skill vector: " + skillVector);
        }
        DoubleArrayList copy = new DoubleArrayList();
        DoubleListIterator doubleListIterator2 = skillVector.iterator();
        while (doubleListIterator2.hasNext()) {
            double d = (Double)doubleListIterator2.next();
            copy.add(d / sum);
        }
        return copy;
    }

    private double getSkillOfRankedObject(ShortList ranking, int indexOfObjectInRanking, DoubleList skillVector) {
        return skillVector.getDouble((int)ranking.getShort(indexOfObjectInRanking));
    }

    private DoubleList getUpdatedSkillVectorImproved(DoubleList skillVector) {
        DoubleArrayList updatedVector = new DoubleArrayList();
        double[][] accumulatedSkills = new double[this.numRankings][];
        for (int j = 0; j < this.numRankings; ++j) {
            int i;
            ShortList ranking = this.rankings.get(j);
            double[] accumulatedSkillsForThisRanking = new double[ranking.size() - 1];
            int numNodes = accumulatedSkillsForThisRanking.length;
            accumulatedSkills[j] = accumulatedSkillsForThisRanking;
            accumulatedSkillsForThisRanking[numNodes - 1] = this.getSkillOfRankedObject(ranking, this.numObjects - 1, skillVector) + this.getSkillOfRankedObject(ranking, this.numObjects - 2, skillVector);
            for (i = this.numObjects - 3; i >= 0; --i) {
                accumulatedSkillsForThisRanking[i] = accumulatedSkillsForThisRanking[i + 1] + this.getSkillOfRankedObject(ranking, i, skillVector);
            }
            for (i = 0; i < numNodes; ++i) {
                accumulatedSkillsForThisRanking[i] = 1.0 / accumulatedSkillsForThisRanking[i];
            }
        }
        for (int t = 0; t < this.numObjects; t = (int)((short)(t + 1))) {
            double denominator = 0.0;
            block4: for (int j = 0; j < this.numRankings; ++j) {
                ShortList ranking = this.rankings.get(j);
                double[] accumulatedSkillsForThisRanking = accumulatedSkills[j];
                for (int i = 0; i < accumulatedSkillsForThisRanking.length; ++i) {
                    denominator += accumulatedSkillsForThisRanking[i];
                    if (ranking.getShort(i) == t) continue block4;
                }
            }
            if (denominator == 0.0) {
                throw new IllegalStateException("Denominator in PL-model must not be null.");
            }
            updatedVector.add((double)this.winVector.getInt(t) / denominator);
        }
        return updatedVector;
    }

    private IntList getWinVector() {
        IntArrayList wins = new IntArrayList();
        for (short t = 0; t < this.numObjects; t = (short)(t + 1)) {
            int w = 0;
            for (ShortList ranking : ((PLInferenceProblem)this.getInput()).getRankings()) {
                if (ranking.indexOf(t) >= ranking.size() - 1) continue;
                ++w;
            }
            wins.add(w);
        }
        return wins;
    }

    public DoubleList call() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        this.next();
        if (this.skillVector.size() != this.numObjects) {
            throw new IllegalStateException("Have " + this.skillVector.size() + " skills (" + this.skillVector + ") for " + this.numObjects + " objects.");
        }
        DoubleListIterator doubleListIterator = this.skillVector.iterator();
        while (doubleListIterator.hasNext()) {
            double d = (Double)doubleListIterator.next();
            if (!Double.isNaN(d)) continue;
            throw new IllegalStateException("Illegal skill return value: " + this.skillVector);
        }
        return this.skillVector;
    }

    public DoubleList getSkillVector() {
        return this.skillVector;
    }
}

