/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.math.bayesianinference;

import ai.libs.jaicore.basic.sets.SetUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DiscreteProbabilityDistribution {
    private final List<String> variables = new ArrayList<String>();
    private final Map<Set<String>, Double> probabilities = new HashMap<Set<String>, Double>();

    public void addProbability(Collection<String> variablesThatAreTrue, double probability) {
        for (String newVar : SetUtil.difference(variablesThatAreTrue, this.variables)) {
            this.variables.add(newVar);
        }
        this.probabilities.put((Set<String>)(variablesThatAreTrue instanceof Set ? (Set<Object>)variablesThatAreTrue : new HashSet<String>(variablesThatAreTrue)), probability);
    }

    public Map<Set<String>, Double> getProbabilities() {
        return this.probabilities;
    }

    public List<String> getVariables() {
        return this.variables;
    }

    public DiscreteProbabilityDistribution getNormalizedCopy() {
        double sum = 0.0;
        ArrayList<Set<String>> assignments = new ArrayList<Set<String>>();
        for (Map.Entry<Set<String>, Double> prob : this.probabilities.entrySet()) {
            sum += prob.getValue().doubleValue();
            assignments.add(prob.getKey());
        }
        if (sum == 0.0) {
            throw new IllegalStateException("Cannot normalize a distribution with zero mass.");
        }
        double alpha = 1.0 / sum;
        DiscreteProbabilityDistribution newDist = new DiscreteProbabilityDistribution();
        for (Set set : assignments) {
            newDist.addProbability(set, this.probabilities.get(set) * alpha);
        }
        return newDist;
    }
}

