/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.math.gradientdescent;

import ai.libs.jaicore.math.gradientdescent.IGradientDescendableFunction;
import ai.libs.jaicore.math.gradientdescent.IGradientFunction;
import ai.libs.jaicore.math.linearalgebra.DenseDoubleVector;
import org.api4.java.common.math.IVector;

public class BlackBoxGradient
implements IGradientFunction {
    private final double precision;
    private final IGradientDescendableFunction function;

    public BlackBoxGradient(IGradientDescendableFunction underlyingFunction, double precision) {
        this.precision = precision;
        this.function = underlyingFunction;
    }

    @Override
    public IVector apply(IVector xVec) {
        DenseDoubleVector gradient = new DenseDoubleVector(xVec.length());
        double fX = this.function.apply(xVec);
        DenseDoubleVector xPrime = new DenseDoubleVector(xVec.asArray());
        for (int i = 0; i < xVec.length(); ++i) {
            if (i > 0) {
                xPrime.setValue(i - 1, xPrime.getValue(i - 1) - this.precision);
            }
            xPrime.setValue(i, xPrime.getValue(i) + this.precision);
            double fXPrime = this.function.apply(xPrime);
            double partial = fXPrime - fX;
            gradient.setValue(i, partial);
        }
        return gradient;
    }
}

