/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.math.linearalgebra;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.ToDoubleFunction;

public class AffineFunction
implements ToDoubleFunction<Number> {
    private final double a;
    private final double b;

    public AffineFunction(double a, double b) {
        this.a = a;
        this.b = b;
    }

    public AffineFunction(BigDecimal x1, BigDecimal y1, BigDecimal x2, BigDecimal y2) {
        this.a = y1.subtract(y2).doubleValue() / x1.subtract(x2).doubleValue();
        this.b = y1.subtract(x1.multiply(BigDecimal.valueOf(this.a))).doubleValue();
    }

    public AffineFunction(double x1, double y1, double x2, double y2) {
        if (x1 == x2) {
            throw new IllegalArgumentException("Cannot create an affine function from two points with the same x-choordinate " + x1 + ".");
        }
        this.a = (y1 - y2) / (x1 - x2);
        this.b = y1 - this.a * x1;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    @Override
    public double applyAsDouble(Number t) {
        if (t instanceof BigDecimal) {
            return ((BigDecimal)t).multiply(BigDecimal.valueOf(this.a)).add(BigDecimal.valueOf(this.b)).doubleValue();
        }
        if (t instanceof BigInteger) {
            return new BigDecimal((BigInteger)t).multiply(BigDecimal.valueOf(this.a)).add(BigDecimal.valueOf(this.b)).doubleValue();
        }
        if (t instanceof Integer) {
            return this.a * (double)((Integer)t).intValue() + this.b;
        }
        return this.a * (Double)t + this.b;
    }
}

