/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.math.bayesianinference;

import ai.libs.jaicore.basic.algorithm.AAlgorithm;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.math.bayesianinference.BayesNet;
import ai.libs.jaicore.math.bayesianinference.BayesianInferenceProblem;
import ai.libs.jaicore.math.bayesianinference.DiscreteProbabilityDistribution;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;

public abstract class ABayesianInferenceAlgorithm
extends AAlgorithm<BayesianInferenceProblem, DiscreteProbabilityDistribution> {
    protected final BayesNet net = ((BayesianInferenceProblem)this.getInput()).getNetwork();
    protected final Collection<String> queryVariables = ((BayesianInferenceProblem)this.getInput()).getQueryVariables();
    protected final Map<String, Boolean> evidence = ((BayesianInferenceProblem)this.getInput()).getEvidenceVariables();
    protected final Set<String> allModelVariables = this.net.getMap().keySet();
    protected final Collection<String> hiddenVariables = SetUtil.difference(this.allModelVariables, (Collection)SetUtil.union((Collection[])new Collection[]{this.queryVariables, this.evidence.keySet()}));
    private DiscreteProbabilityDistribution distribution = new DiscreteProbabilityDistribution();

    public ABayesianInferenceAlgorithm(BayesianInferenceProblem input) {
        super((Object)input);
    }

    public BayesNet getNet() {
        return this.net;
    }

    public Collection<String> getQueryVariables() {
        return this.queryVariables;
    }

    public Map<String, Boolean> getEvidence() {
        return this.evidence;
    }

    public Set<String> getAllModelVariables() {
        return this.allModelVariables;
    }

    public Collection<String> getHiddenVariables() {
        return this.hiddenVariables;
    }

    public DiscreteProbabilityDistribution getDistribution() {
        return this.distribution;
    }

    protected void setDistribution(DiscreteProbabilityDistribution distribution) {
        this.distribution = distribution;
    }

    public DiscreteProbabilityDistribution call() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        this.nextWithException();
        this.distribution = this.distribution.getNormalizedCopy();
        return this.distribution;
    }
}

