/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.math.linearalgebra;

import ai.libs.jaicore.math.linearalgebra.DenseDoubleVector;
import ai.libs.jaicore.math.linearalgebra.SparseDoubleVector;
import org.api4.java.common.math.IVector;

public abstract class AbstractVector
implements IVector {
    public void squareRoot() {
        for (int i = 0; i < this.length(); ++i) {
            this.setValue(i, Math.sqrt(this.getValue(i)));
        }
    }

    public IVector squareRootToCopy() {
        IVector copy = this.duplicate();
        for (int i = 0; i < this.length(); ++i) {
            copy.setValue(i, Math.sqrt(this.getValue(i)));
        }
        return copy;
    }

    public void incrementValueAt(int index, double amount) {
        this.setValue(index, amount + this.getValue(index));
    }

    public double sum() {
        double sum = 0.0;
        for (int i = 0; i < this.length(); ++i) {
            sum += this.getValue(i);
        }
        return sum;
    }

    public double mean() {
        return this.sum() / (double)this.length();
    }

    public double standardDeviation() {
        double mean = this.mean();
        double std = 0.0;
        for (int i = 0; i < this.length(); ++i) {
            std += Math.pow(mean - this.getValue(i), 2.0);
        }
        return Math.sqrt(std /= (double)this.length());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        sb.append(this.getValue(0));
        for (int i = 1; i < this.length(); ++i) {
            sb.append(",").append(this.getValue(i));
        }
        sb.append(")");
        return sb.toString();
    }

    protected double[] kroneckerProductInternal(double[] vectorAsArray) {
        double[] kroneckerProduct = new double[this.length() * vectorAsArray.length];
        int counter = 0;
        for (int i = 0; i < this.length(); ++i) {
            for (int j = 0; j < vectorAsArray.length; ++j) {
                kroneckerProduct[counter++] = this.getValue(i) * vectorAsArray[j];
            }
        }
        return kroneckerProduct;
    }

    public void zeroAllDimensions() {
        for (int i = 0; i < this.length(); ++i) {
            this.setValue(i, 0.0);
        }
    }

    public double euclideanNorm() {
        return Math.sqrt(this.dotProduct(this));
    }

    public IVector addVectorToCopy(double[] vectorAsArray) {
        IVector vector = this.duplicate();
        vector.addVector(vectorAsArray);
        return vector;
    }

    public IVector subtractVectorFromCopy(double[] vectorAsArray) {
        IVector vector = this.duplicate();
        vector.subtractVector(vectorAsArray);
        return vector;
    }

    public IVector multiplyByVectorPairwiseToCopy(double[] vectorAsArray) {
        IVector vector = this.duplicate();
        vector.multiplyByVectorPairwise(vectorAsArray);
        return vector;
    }

    public IVector divideByVectorPairwiseToCopy(double[] vectorAsArray) {
        IVector vector = this.duplicate();
        vector.divideByVectorPairwise(vectorAsArray);
        return vector;
    }

    public IVector addConstantToCopy(double constant) {
        IVector vector = this.duplicate();
        vector.addConstant(constant);
        return vector;
    }

    public IVector addVectorToCopy(IVector vector) {
        IVector vectorCopy = this.duplicate();
        vectorCopy.addVector(vector);
        return vectorCopy;
    }

    public IVector subtractConstantFromCopy(double constant) {
        IVector vectorCopy = this.duplicate();
        vectorCopy.subtractConstant(constant);
        return vectorCopy;
    }

    public IVector subtractVectorFromCopy(IVector vector) {
        IVector vectorCopy = this.duplicate();
        vectorCopy.subtractVector(vector);
        return vectorCopy;
    }

    public IVector multiplyByVectorPairwiseToCopy(IVector vector) {
        IVector vectorCopy = this.duplicate();
        vectorCopy.multiplyByVectorPairwise(vector);
        return vectorCopy;
    }

    public IVector multiplyByConstantToCopy(double constant) {
        IVector vectorCopy = this.duplicate();
        vectorCopy.multiplyByConstant(constant);
        return vectorCopy;
    }

    public IVector divideByVectorPairwiseToCopy(IVector vector) {
        IVector vectorCopy = this.duplicate();
        vectorCopy.divideByVectorPairwise(vector);
        return vectorCopy;
    }

    public IVector divideByConstantToCopy(double constant) {
        IVector vectorCopy = this.duplicate();
        vectorCopy.divideByConstant(constant);
        return vectorCopy;
    }

    public Double average() {
        double basisAverage = 0.0;
        for (int i = 0; i < this.length(); ++i) {
            basisAverage += this.getValue(i);
        }
        return basisAverage /= (double)this.length();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractVector) {
            AbstractVector vector = (AbstractVector)obj;
            for (int i = 0; i < vector.length(); ++i) {
                if (!(Math.abs(vector.getValue(i) - this.getValue(i)) > 1.0E-17)) continue;
                return false;
            }
            return true;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.length(); ++i) {
            hashCode = 31 * hashCode + Double.valueOf(this.getValue(i)).hashCode();
        }
        return hashCode;
    }

    public abstract DenseDoubleVector toDenseVector();

    public abstract SparseDoubleVector toSparseVector();
}

