/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.math.linearalgebra;

import ai.libs.jaicore.math.linearalgebra.AbstractVector;
import ai.libs.jaicore.math.linearalgebra.DenseDoubleVector;
import ai.libs.jaicore.math.random.RandomGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.SparseVector;
import org.api4.java.common.math.IVector;

public class SparseDoubleVector
extends AbstractVector {
    protected SparseVector internalVector;
    private boolean isChanged = true;

    public SparseDoubleVector(int[] indices, double[] values, int dimension) {
        this.internalVector = new SparseVector(dimension, indices, values);
        this.setIsChanged();
    }

    public SparseDoubleVector(int dimension) {
        this.internalVector = new SparseVector(dimension);
    }

    public SparseDoubleVector(double[] data) {
        ArrayList<Integer> indicesWithNonZeroEntry = new ArrayList<Integer>();
        ArrayList<Double> nonZeroEntries = new ArrayList<Double>();
        for (int i2 = 0; i2 < data.length; ++i2) {
            if (Double.compare(data[i2], 0.0) == 0) continue;
            indicesWithNonZeroEntry.add(i2);
            nonZeroEntries.add(data[i2]);
        }
        this.internalVector = new SparseVector(data.length, indicesWithNonZeroEntry.stream().mapToInt(i -> i).toArray(), nonZeroEntries.stream().mapToDouble(d -> d).toArray());
        this.setIsChanged();
    }

    public SparseDoubleVector(SparseVector mtjVector) {
        this.internalVector = mtjVector;
        this.setIsChanged();
    }

    public void addVector(double[] vectorAsArray) {
        this.setIsChanged();
        this.addVector(new SparseDoubleVector(vectorAsArray));
    }

    public void subtractVector(double[] vectorAsArray) {
        this.setIsChanged();
        this.internalVector = (SparseVector)this.internalVector.add(-1.0, (Vector)new SparseDoubleVector((double[])vectorAsArray).internalVector);
    }

    public void multiplyByVectorPairwise(double[] vectorAsArray) {
        this.setIsChanged();
        SparseVector vector = this.internalVector;
        int[] indexes = vector.getIndex();
        for (int i = 0; i < indexes.length; ++i) {
            vector.set(indexes[i], vector.get(indexes[i]) * vectorAsArray[indexes[i]]);
        }
    }

    public void divideByVectorPairwise(double[] vectorAsArray) {
        this.setIsChanged();
        SparseVector vector = this.internalVector;
        int[] indexes = vector.getIndex();
        for (int i = 0; i < indexes.length; ++i) {
            vector.set(indexes[i], vector.get(indexes[i]) / vectorAsArray[indexes[i]]);
        }
    }

    public double dotProduct(double[] vectorAsArray) {
        return this.internalVector.dot((Vector)new DenseVector(vectorAsArray));
    }

    public int length() {
        return this.internalVector.size();
    }

    public double getValue(int index) {
        return this.internalVector.get(index);
    }

    public void setValue(int index, double value) {
        this.setIsChanged();
        this.internalVector.set(index, value);
    }

    public void addVector(IVector vector) {
        this.setIsChanged();
        this.internalVector = (SparseVector)this.internalVector.add((Vector)((AbstractVector)vector).toSparseVector().internalVector);
    }

    public void subtractVector(IVector vector) {
        this.setIsChanged();
        this.internalVector = (SparseVector)this.internalVector.add(-1.0, (Vector)((AbstractVector)vector).toSparseVector().internalVector);
    }

    public void multiplyByVectorPairwise(IVector secondVector) {
        this.setIsChanged();
        SparseVector sparseVector = this.internalVector;
        int[] indexes = sparseVector.getIndex();
        for (int i = 0; i < indexes.length; ++i) {
            sparseVector.set(indexes[i], sparseVector.get(indexes[i]) * secondVector.getValue(indexes[i]));
        }
    }

    public void multiplyByConstant(double constant) {
        this.setIsChanged();
        this.internalVector = this.internalVector.scale(constant);
    }

    public void divideByVectorPairwise(IVector secondVector) {
        this.setIsChanged();
        SparseVector sparseVector = this.internalVector;
        int[] indexes = sparseVector.getIndex();
        for (int i = 0; i < indexes.length; ++i) {
            sparseVector.set(indexes[i], sparseVector.get(indexes[i]) / secondVector.getValue(indexes[i]));
        }
    }

    public void divideByConstant(double constant) {
        this.setIsChanged();
        this.internalVector = this.internalVector.scale(1.0 / constant);
    }

    public double dotProduct(IVector vector) {
        return this.internalVector.dot((Vector)((AbstractVector)vector).toSparseVector().internalVector);
    }

    public boolean isSparse() {
        return true;
    }

    public double[] asArray() {
        double[] result = new double[this.internalVector.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.internalVector.get(i);
        }
        return result;
    }

    @Override
    public DenseDoubleVector toDenseVector() {
        return new DenseDoubleVector(this.asArray());
    }

    @Override
    public SparseDoubleVector toSparseVector() {
        return this;
    }

    public IVector duplicate() {
        return new SparseDoubleVector(this.asArray());
    }

    public void normalize() {
        this.setIsChanged();
        this.internalVector = this.internalVector.scale(this.internalVector.norm(Vector.Norm.Two));
    }

    public void addConstant(double constant) {
        this.setIsChanged();
        double[] contantAsVector = new double[this.internalVector.size()];
        for (int i = 0; i < contantAsVector.length; ++i) {
            contantAsVector[i] = constant;
        }
        this.addVector(contantAsVector);
    }

    public void subtractConstant(double constant) {
        this.setIsChanged();
        this.addConstant(-1.0 * constant);
    }

    public void fillRandomly() {
        this.setIsChanged();
        Random random = RandomGenerator.getRNG();
        int numberToAdd = random.nextInt(this.internalVector.size());
        List unfilledIndexes = IntStream.range(0, this.internalVector.size()).mapToObj(x -> x).collect(Collectors.toList());
        for (int numberOfAddedValues = 0; numberOfAddedValues < numberToAdd; ++numberOfAddedValues) {
            int randomIndex = random.nextInt(unfilledIndexes.size());
            int toBeFilledIndex = (Integer)unfilledIndexes.get(randomIndex);
            double fillValue = random.nextDouble();
            this.internalVector.set(toBeFilledIndex, fillValue);
            unfilledIndexes.remove(0);
        }
    }

    public int[] getNonZeroIndices() {
        if (this.isChanged) {
            ArrayList<Integer> indicesWithNonZeroEntry = new ArrayList<Integer>(this.length());
            ArrayList<Double> nonZeroEntries = new ArrayList<Double>(this.length());
            for (int i2 = 0; i2 < this.length(); ++i2) {
                double value = this.internalVector.get(i2);
                if (Double.compare(value, 0.0) == 0) continue;
                indicesWithNonZeroEntry.add(i2);
                nonZeroEntries.add(value);
            }
            if (indicesWithNonZeroEntry.size() != this.internalVector.getIndex().length) {
                this.internalVector = new SparseVector(indicesWithNonZeroEntry.size(), indicesWithNonZeroEntry.stream().mapToInt(i -> i).toArray(), nonZeroEntries.stream().mapToDouble(d -> d).toArray());
            }
            this.setUnchanged();
        }
        return this.internalVector.getIndex();
    }

    private void setIsChanged() {
        this.isChanged = true;
    }

    private void setUnchanged() {
        this.isChanged = false;
    }

    public IVector kroneckerProduct(double[] vectorAsArray) {
        return new SparseDoubleVector(this.kroneckerProductInternal(vectorAsArray));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.internalVector == null ? 0 : this.internalVector.hashCode());
        result = 31 * result + (this.isChanged ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SparseDoubleVector other = (SparseDoubleVector)obj;
        if (this.isChanged != other.isChanged) {
            return false;
        }
        return Arrays.equals(this.asArray(), other.asArray());
    }
}

