/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.math.random;

import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RandomGenerator.class);
    private static final String INITIALIZING_THE_RANDOM_GENERATOR_TO_SEED = "Initializing the random generator to seed: %d .";
    private static final String INITIALIZING_RANDOM_GENERATOR = "Random number generator not initialized; initializing to 1234.";
    public static final int DEFAULT_SEED = 1234;
    private static Random randomVariable = null;
    private static long seed = -1L;

    private RandomGenerator() {
        throw new IllegalAccessError("Utility class");
    }

    public static void initializeRNG(long seed) {
        RandomGenerator.seed = seed;
        randomVariable = new Random(seed);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format(INITIALIZING_THE_RANDOM_GENERATOR_TO_SEED, seed));
        }
    }

    public static Random getRNG() {
        if (randomVariable == null) {
            LOGGER.warn(INITIALIZING_RANDOM_GENERATOR);
            RandomGenerator.initializeRNG(1234L);
        }
        return randomVariable;
    }

    public static long getSeed() {
        return seed;
    }
}

