/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.singlelabel.timeseries.util;

import ai.libs.jaicore.ml.classification.singlelabel.timeseries.dataset.TimeSeriesDataset2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;
import org.api4.java.ai.ml.core.exception.TrainingException;
import weka.classifiers.Classifier;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class WekaTimeseriesUtil {
    private static final String I_NAME = "Instances";

    private WekaTimeseriesUtil() {
    }

    public static Instance simplifiedTSInstanceToWekaInstance(double[] instance) {
        return new DenseInstance(1.0, instance);
    }

    public static void buildWekaClassifierFromSimplifiedTS(Classifier classifier, TimeSeriesDataset2 timeSeriesDataset) throws TrainingException {
        Instances trainingInstances = WekaTimeseriesUtil.simplifiedTimeSeriesDatasetToWekaInstances(timeSeriesDataset);
        try {
            classifier.buildClassifier(trainingInstances);
        }
        catch (Exception e) {
            throw new TrainingException(String.format("Could not train classifier %s due to a Weka exception.", classifier.getClass().getName()), (Throwable)e);
        }
    }

    public static Instances simplifiedTimeSeriesDatasetToWekaInstances(TimeSeriesDataset2 dataSet) {
        int[] targets = dataSet.getTargets();
        List<Integer> targetList = Arrays.asList(ArrayUtils.toObject((int[])targets));
        int min = Collections.min(targetList);
        int max = Collections.max(targetList);
        List<String> classValues = IntStream.rangeClosed(min, max).boxed().map(String::valueOf).collect(Collectors.toList());
        return WekaTimeseriesUtil.simplifiedTimeSeriesDatasetToWekaInstances(dataSet, classValues);
    }

    public static Instances simplifiedTimeSeriesDatasetToWekaInstances(TimeSeriesDataset2 dataSet, List<String> classValues) {
        int i;
        ArrayList<double[][]> matrices = new ArrayList<double[][]>();
        for (int i2 = 0; i2 < dataSet.getNumberOfVariables(); ++i2) {
            matrices.add(dataSet.getValues(i2));
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (int m = 0; m < matrices.size(); ++m) {
            double[][] matrix = (double[][])matrices.get(m);
            if (matrix == null) continue;
            for (i = 0; i < matrix[0].length; ++i) {
                Attribute newAtt = new Attribute(String.format("val_%d_%d", m, i));
                attributes.add(newAtt);
            }
        }
        int[] targets = dataSet.getTargets();
        attributes.add(new Attribute("class", classValues));
        Instances result = new Instances(I_NAME, attributes, dataSet.getNumberOfInstances());
        result.setClassIndex(result.numAttributes() - 1);
        for (i = 0; i < dataSet.getNumberOfInstances(); ++i) {
            double[] concatenatedRow = ((double[][])matrices.get(0))[i];
            for (int j = 1; j < matrices.size(); ++j) {
                concatenatedRow = ArrayUtils.addAll((double[])concatenatedRow, (double[])((double[][])matrices.get(j))[i]);
            }
            concatenatedRow = ArrayUtils.addAll((double[])concatenatedRow, (double[])new double[]{targets[i]});
            DenseInstance inst = new DenseInstance(1.0, concatenatedRow);
            inst.setDataset(result);
            result.add((Instance)inst);
        }
        return result;
    }

    public static Instances matrixToWekaInstances(double[][] matrix) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (int i = 0; i < matrix[0].length; ++i) {
            Attribute newAtt = new Attribute("val" + i);
            attributes.add(newAtt);
        }
        Instances wekaInstances = new Instances(I_NAME, attributes, matrix.length);
        for (int i = 0; i < matrix[0].length; ++i) {
            DenseInstance inst = new DenseInstance(1.0, matrix[i]);
            inst.setDataset(wekaInstances);
            wekaInstances.add((Instance)inst);
        }
        return wekaInstances;
    }
}

