/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.ranking.label.learner.clusterbased.modifiedisac;

import ai.libs.jaicore.ml.clustering.learner.GMeans;
import ai.libs.jaicore.ml.ranking.label.learner.clusterbased.customdatatypes.GroupIdentifier;
import ai.libs.jaicore.ml.ranking.label.learner.clusterbased.customdatatypes.ProblemInstance;
import ai.libs.jaicore.ml.ranking.label.learner.clusterbased.modifiedisac.Cluster;
import ai.libs.jaicore.ml.ranking.label.learner.clusterbased.modifiedisac.L1DistanceMetric;
import ai.libs.jaicore.ml.ranking.label.learner.clusterbased.modifiedisac.ModifiedISACkMeans;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.math3.ml.clustering.DoublePoint;
import weka.core.Instance;

public class ModifiedISACgMeans
extends GMeans<DoublePoint> {
    private List<Cluster> gmeansCluster;
    private List<double[]> intermediateCenter;
    private Map<double[], List<double[]>> currentPoints;
    private Map<double[], List<double[]>> intermediatePoints;
    private List<double[]> loopPoints;
    private Map<double[], ProblemInstance<Instance>> pointToInstance;
    private L1DistanceMetric dist = new L1DistanceMetric();

    public ModifiedISACgMeans(List<double[]> toClusterPoints, List<ProblemInstance<Instance>> instances) {
        super((Collection)toClusterPoints.stream().map(DoublePoint::new).collect(Collectors.toList()));
        this.pointToInstance = new HashMap<double[], ProblemInstance<Instance>>();
        for (int i = 0; i < instances.size(); ++i) {
            this.pointToInstance.put(toClusterPoints.get(i), instances.get(i));
        }
        this.gmeansCluster = new ArrayList<Cluster>();
    }

    public List<Cluster> clusterDeprecated() {
        HashMap<Integer, double[]> positionOfCenter = new HashMap<Integer, double[]>();
        int tmp = 1;
        int k = 1;
        int i = 1;
        ModifiedISACkMeans test = new ModifiedISACkMeans(this.getPoints().stream().map(DoublePoint::getPoint).collect(Collectors.toList()), this.dist);
        this.currentPoints = test.kmeanscluster(k);
        for (double[] d : this.currentPoints.keySet()) {
            this.getCentersModifiable().add(d);
        }
        for (double[] c : this.getCentersModifiable()) {
            positionOfCenter.put(tmp, c);
            ++tmp;
        }
        while (i <= k) {
            this.loopPoints = this.currentPoints.get(positionOfCenter.get(i));
            ModifiedISACkMeans loopCluster = new ModifiedISACkMeans(this.loopPoints, this.dist);
            this.intermediatePoints = loopCluster.kmeanscluster(2);
            this.intermediateCenter = loopCluster.getCenter();
            double[] v = this.difference(this.intermediateCenter.get(0), this.intermediateCenter.get(1));
            double w = 0.0;
            for (int l = 0; l < v.length; ++l) {
                if (Double.isNaN(v[l])) continue;
                w += Math.pow(v[l], 2.0);
            }
            double[] y = new double[this.loopPoints.size()];
            for (int r = 0; r < this.loopPoints.size(); ++r) {
                for (int p = 0; p < this.loopPoints.get(r).length; ++p) {
                    if (Double.isNaN(this.loopPoints.get(r)[p])) continue;
                    if (!Double.isNaN(v[p]) && w != 0.0) {
                        int n = r;
                        y[n] = y[n] + v[p] * this.loopPoints.get(r)[p] / w;
                        continue;
                    }
                    throw new UnsupportedOperationException("We have not covered this case yet!");
                }
            }
            if (!this.andersonDarlingTest(y)) {
                this.currentPoints.remove(positionOfCenter.get(i));
                this.currentPoints.put(this.intermediateCenter.get(0), this.intermediatePoints.get(this.intermediateCenter.get(0)));
                positionOfCenter.replace(i, this.intermediateCenter.get(0));
                this.currentPoints.put(this.intermediateCenter.get(1), this.intermediatePoints.get(this.intermediateCenter.get(1)));
                positionOfCenter.put(++k, this.intermediateCenter.get(1));
                continue;
            }
            ++i;
        }
        HashMap mapOfCurrentPoints = new HashMap();
        for (Map.Entry<double[], List<double[]>> currentPointMap : this.currentPoints.entrySet()) {
            mapOfCurrentPoints.put(currentPointMap.getKey(), currentPointMap.getValue().stream().map(DoublePoint::new).collect(Collectors.toList()));
        }
        this.mergeCluster(mapOfCurrentPoints);
        for (Map.Entry<double[], List<double[]>> d : this.currentPoints.entrySet()) {
            List<double[]> pointsInCluster = d.getValue();
            ArrayList<ProblemInstance<Instance>> instancesInCluster = new ArrayList<ProblemInstance<Instance>>();
            for (double[] point : pointsInCluster) {
                instancesInCluster.add(this.pointToInstance.get(point));
            }
            this.gmeansCluster.add(new Cluster(instancesInCluster, (GroupIdentifier<double[]>)new GroupIdentifier((Object)d.getKey())));
        }
        return this.gmeansCluster;
    }

    public List<Cluster> getGmeansCluster() {
        return this.gmeansCluster;
    }

    public List<double[]> getIntermediateCenter() {
        return this.intermediateCenter;
    }

    public Map<double[], List<double[]>> getCurrentPoints() {
        return this.currentPoints;
    }

    public Map<double[], List<double[]>> getIntermediatePoints() {
        return this.intermediatePoints;
    }

    public List<double[]> getLoopPoints() {
        return this.loopPoints;
    }

    public Map<double[], ProblemInstance<Instance>> getPointToInstance() {
        return this.pointToInstance;
    }
}

