/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.weka;

import ai.libs.jaicore.basic.sets.CartesianProductComputationProblem;
import ai.libs.jaicore.basic.sets.LDSRelationComputer;
import ai.libs.jaicore.basic.sets.RelationComputationProblem;
import ai.libs.jaicore.ml.core.filter.sampling.inmemory.stratified.sampling.LabelBasedStratifiedSampling;
import ai.libs.jaicore.ml.weka.dataset.IWekaInstance;
import ai.libs.jaicore.ml.weka.dataset.IWekaInstances;
import ai.libs.jaicore.ml.weka.dataset.WekaInstances;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.api4.java.ai.ml.core.dataset.splitter.SplitFailedException;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.exception.DatasetCreationException;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.MultipleClassifiersCombiner;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.functions.SMO;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.InstanceComparator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.json.JSONInstances;
import weka.core.json.JSONNode;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class WekaUtil {
    private static final String MSG_SUM1 = "Portions must sum up to at most 1.";
    private static final String MSG_DEVIATING_NUMBER_OF_INSTANCES = "The number of instances in the folds does not equal the number of instances in the original dataset";
    private static boolean debug = false;

    private WekaUtil() {
    }

    public static Collection<String> getBasicLearners() {
        ArrayList<String> classifiers = new ArrayList<String>();
        classifiers.add("weka.classifiers.bayes.BayesNet");
        classifiers.add("weka.classifiers.bayes.NaiveBayes");
        classifiers.add("weka.classifiers.bayes.NaiveBayesMultinomial");
        classifiers.add("weka.classifiers.functions.Logistic");
        classifiers.add("weka.classifiers.functions.MultilayerPerceptron");
        classifiers.add("weka.classifiers.functions.SimpleLinearRegression");
        classifiers.add("weka.classifiers.functions.SimpleLogistic");
        classifiers.add("weka.classifiers.functions.SMO");
        classifiers.add("weka.classifiers.functions.VotedPerceptron");
        classifiers.add("weka.classifiers.lazy.IBk");
        classifiers.add("weka.classifiers.lazy.KStar");
        classifiers.add("weka.classifiers.rules.JRip");
        classifiers.add("weka.classifiers.rules.M5Rules");
        classifiers.add("weka.classifiers.rules.OneR");
        classifiers.add("weka.classifiers.rules.PART");
        classifiers.add("weka.classifiers.rules.ZeroR");
        classifiers.add("weka.classifiers.trees.DecisionStump");
        classifiers.add("weka.classifiers.trees.J48");
        classifiers.add("weka.classifiers.trees.LMT");
        classifiers.add("weka.classifiers.trees.M5P");
        classifiers.add("weka.classifiers.trees.RandomForest");
        classifiers.add("weka.classifiers.trees.RandomTree");
        classifiers.add("weka.classifiers.trees.REPTree");
        return classifiers;
    }

    public static Collection<String> getNativeMultiClassClassifiers() {
        ArrayList<String> classifiers = new ArrayList<String>();
        classifiers.add("weka.classifiers.bayes.BayesNet");
        classifiers.add("weka.classifiers.bayes.NaiveBayes");
        classifiers.add("weka.classifiers.bayes.NaiveBayesMultinomial");
        classifiers.add("weka.classifiers.functions.Logistic");
        classifiers.add("weka.classifiers.functions.MultilayerPerceptron");
        classifiers.add("weka.classifiers.functions.SimpleLogistic");
        classifiers.add("weka.classifiers.lazy.IBk");
        classifiers.add("weka.classifiers.lazy.KStar");
        classifiers.add("weka.classifiers.rules.JRip");
        classifiers.add("weka.classifiers.rules.M5Rules");
        classifiers.add("weka.classifiers.rules.OneR");
        classifiers.add("weka.classifiers.rules.PART");
        classifiers.add("weka.classifiers.rules.ZeroR");
        classifiers.add("weka.classifiers.trees.DecisionStump");
        classifiers.add("weka.classifiers.trees.J48");
        classifiers.add("weka.classifiers.trees.LMT");
        classifiers.add("weka.classifiers.trees.M5P");
        classifiers.add("weka.classifiers.trees.RandomForest");
        classifiers.add("weka.classifiers.trees.RandomTree");
        classifiers.add("weka.classifiers.trees.REPTree");
        return classifiers;
    }

    public static Collection<String> getBinaryClassifiers() {
        ArrayList<String> classifiers = new ArrayList<String>();
        classifiers.add("weka.classifiers.functions.SMO");
        classifiers.add("weka.classifiers.functions.VotedPerceptron");
        return classifiers;
    }

    public static Collection<String> getFeatureEvaluators() {
        ArrayList<String> preprocessors = new ArrayList<String>();
        preprocessors.add("weka.attributeSelection.CfsSubsetEval");
        preprocessors.add("weka.attributeSelection.CorrelationAttributeEval");
        preprocessors.add("weka.attributeSelection.GainRatioAttributeEval");
        preprocessors.add("weka.attributeSelection.InfoGainAttributeEval");
        preprocessors.add("weka.attributeSelection.OneRAttributeEval");
        preprocessors.add("weka.attributeSelection.PrincipalComponents");
        preprocessors.add("weka.attributeSelection.ReliefFAttributeEval");
        preprocessors.add("weka.attributeSelection.SymmetricalUncertAttributeEval");
        return preprocessors;
    }

    public static Collection<String> getSearchers() {
        ArrayList<String> preprocessors = new ArrayList<String>();
        preprocessors.add("weka.attributeSelection.Ranker");
        preprocessors.add("weka.attributeSelection.BestFirst");
        preprocessors.add("weka.attributeSelection.GreedyStepwise");
        return preprocessors;
    }

    public static Collection<String> getMetaLearners() {
        ArrayList<String> classifiers = new ArrayList<String>();
        classifiers.add("weka.classifiers.meta.AdaBoostM1");
        classifiers.add("weka.classifiers.meta.AdditiveRegression");
        classifiers.add("weka.classifiers.meta.AttributeSelectedClassifier");
        classifiers.add("weka.classifiers.meta.Bagging");
        classifiers.add("weka.classifiers.meta.ClassificationViaRegression");
        classifiers.add("weka.classifiers.meta.LogitBoost");
        classifiers.add("weka.classifiers.meta.MultiClassClassifier");
        classifiers.add("weka.classifiers.meta.RandomCommittee");
        classifiers.add("weka.classifiers.meta.RandomSubspace");
        classifiers.add("weka.classifiers.meta.Stacking");
        classifiers.add("weka.classifiers.meta.Vote");
        return classifiers;
    }

    public static boolean isValidPreprocessorCombination(String searcher, String evaluator) {
        boolean isSetEvaluator = evaluator.toLowerCase().matches(".*(relief|gainratio|principalcomponents|onerattributeeval|infogainattributeeval|correlationattributeeval|symmetricaluncertattributeeval).*");
        boolean isRanker = searcher.toLowerCase().contains("ranker");
        boolean isNonRankerEvaluator = evaluator.toLowerCase().matches(".*(cfssubseteval).*");
        return !(isSetEvaluator && !isRanker || isNonRankerEvaluator && isRanker);
    }

    public static Collection<List<String>> getAdmissibleSearcherEvaluatorCombinationsForAttributeSelection() throws AlgorithmTimeoutedException, InterruptedException, AlgorithmExecutionCanceledException {
        ArrayList<List<String>> preprocessors = new ArrayList<List<String>>();
        ArrayList<Collection<String>> sets = new ArrayList<Collection<String>>();
        sets.add(WekaUtil.getSearchers());
        sets.add(WekaUtil.getFeatureEvaluators());
        CartesianProductComputationProblem problem = new CartesianProductComputationProblem(sets);
        List combinations = new LDSRelationComputer((RelationComputationProblem)problem).call();
        for (List combo : combinations) {
            if (!WekaUtil.isValidPreprocessorCombination((String)combo.get(0), (String)combo.get(1))) continue;
            preprocessors.add(combo);
        }
        return preprocessors;
    }

    public static boolean needsBinarization(Instances wekaInstances, boolean ignoreClassAttribute) {
        Attribute classAttribute = wekaInstances.classAttribute();
        if (!ignoreClassAttribute && classAttribute.isNominal() && classAttribute.numValues() >= 3) {
            return true;
        }
        Enumeration attributeEnum = wekaInstances.enumerateAttributes();
        while (attributeEnum.hasMoreElements()) {
            Attribute currentAttr = (Attribute)attributeEnum.nextElement();
            if (!currentAttr.isNominal() || currentAttr == classAttribute || currentAttr.numValues() < 3) continue;
            return true;
        }
        return false;
    }

    public static Collection<String> getPossibleClassValues(Instance instance) {
        ArrayList<String> labels = new ArrayList<String>();
        Attribute classAttr = instance.classAttribute();
        for (int i = 0; i < classAttr.numValues(); ++i) {
            labels.add(classAttr.value(i));
        }
        return labels;
    }

    public static String getClassifierDescriptor(Classifier c) {
        return WekaUtil.getDescriptor(c);
    }

    public static String getPreprocessorDescriptor(ASSearch c) {
        return WekaUtil.getDescriptor(c);
    }

    public static String getPreprocessorDescriptor(ASEvaluation c) {
        return WekaUtil.getDescriptor(c);
    }

    public static String getDescriptor(Object o) {
        StringBuilder sb = new StringBuilder();
        sb.append(o.getClass().getName());
        if (o instanceof OptionHandler) {
            sb.append("- [");
            int i = 0;
            for (String s : ((OptionHandler)o).getOptions()) {
                if (i++ > 0) {
                    sb.append(", ");
                }
                sb.append(s);
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public static Collection<Option> getOptionsOfWekaAlgorithm(Object o) {
        ArrayList<Option> options = new ArrayList<Option>();
        if (!(o instanceof OptionHandler)) {
            return options;
        }
        OptionHandler oh = (OptionHandler)o;
        Enumeration optionEnum = oh.listOptions();
        while (optionEnum.hasMoreElements()) {
            options.add((Option)optionEnum.nextElement());
        }
        return options;
    }

    public static List<String> getClassNames(Instance instance) {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration namesEnumration = instance.classAttribute().enumerateValues();
        while (namesEnumration.hasMoreElements()) {
            names.add((String)namesEnumration.nextElement());
        }
        return names;
    }

    public static Map<String, Integer> getClassNameToIDMap(Instance instance) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List<String> classNames = WekaUtil.getClassNames(instance);
        for (int i = 0; i < classNames.size(); ++i) {
            map.put(classNames.get(i), i);
        }
        return map;
    }

    public static int getIntValOfClassName(Instance instance, String className) {
        Map<String, Integer> map = WekaUtil.getClassNameToIDMap(instance);
        return map.containsKey(className) ? map.get(className) : -1;
    }

    public static String getClassSplitAssignments(List<Instances> split) {
        StringBuilder sb = new StringBuilder();
        Map<String, Instances> firstSet = WekaUtil.getInstancesPerClass(split.get(0));
        for (String cl : firstSet.keySet()) {
            sb.append(cl);
            sb.append(": ");
            int i = 0;
            for (Instances set : split) {
                Map<String, Instances> map = WekaUtil.getInstancesPerClass(set);
                sb.append(map.containsKey(cl) ? map.get(cl).size() : 0);
                if (i >= split.size() - 1) continue;
                sb.append("/");
                ++i;
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static Instances getInstancesOfClass(Instances data, Collection<String> classNames) {
        Instances newInstances = new Instances(data);
        newInstances.removeIf(i -> !classNames.contains(WekaUtil.getClassName(i)));
        return newInstances;
    }

    public static Instances getInstancesOfClass(Instances data, String className) {
        Instances newInstances = new Instances(data);
        newInstances.removeIf(i -> !WekaUtil.getClassName(i).equals(className));
        return newInstances;
    }

    public static String getClassName(Instance instance) {
        return WekaUtil.getClassNames(instance).get((int)instance.classValue());
    }

    public static Map<String, Instances> getInstancesPerClass(Instances data) {
        Instances emptyInstances = new Instances(data);
        emptyInstances.clear();
        HashMap<String, Instances> classWiseSeparation = new HashMap<String, Instances>();
        for (Instance i : data) {
            String assignedClass = data.classAttribute().value((int)i.classValue());
            if (!classWiseSeparation.containsKey(assignedClass)) {
                Instances inst = new Instances(emptyInstances);
                classWiseSeparation.put(assignedClass, inst);
            }
            ((Instances)classWiseSeparation.get(assignedClass)).add(i);
        }
        return classWiseSeparation;
    }

    public static Map<String, Integer> getNumberOfInstancesPerClass(Instances data) {
        Map<String, Instances> instancesPerClass = WekaUtil.getInstancesPerClass(data);
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        for (Map.Entry<String, Instances> classWithInstances : instancesPerClass.entrySet()) {
            counter.put(classWithInstances.getKey(), classWithInstances.getValue().size());
        }
        return counter;
    }

    public static int getNumberOfInstancesFromClass(Instances data, String c) {
        return WekaUtil.getInstancesOfClass(data, c).size();
    }

    public static int getNumberOfInstancesFromClass(Instances data, Collection<String> cs) {
        Map<String, Integer> map = WekaUtil.getNumberOfInstancesPerClass(data);
        int sum = 0;
        for (String c : cs) {
            if (!map.containsKey(c)) continue;
            sum += map.get(c).intValue();
        }
        return sum;
    }

    public static double getRelativeNumberOfInstancesFromClass(Instances data, String c) {
        if (data.isEmpty()) {
            return 0.0;
        }
        return (float)WekaUtil.getNumberOfInstancesFromClass(data, c) / (1.0f * (float)data.size());
    }

    public static double getRelativeNumberOfInstancesFromClass(Instances data, Collection<String> cs) {
        return (float)WekaUtil.getNumberOfInstancesFromClass(data, cs) / (1.0f * (float)data.size());
    }

    public static Collection<Integer>[] getArbitrarySplit(IWekaInstances data, Random rand, double ... portions) {
        double sum = 0.0;
        for (double p : portions) {
            sum += p;
        }
        if (sum > 1.0) {
            throw new IllegalArgumentException(MSG_SUM1);
        }
        LinkedList indices = new LinkedList(ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(data.size() - 1)), (DiscreteDomain)DiscreteDomain.integers()).asList());
        Collections.shuffle(indices, rand);
        ArrayList[] folds = new ArrayList[portions.length + 1];
        Instances emptyInstances = new Instances(data.getList());
        emptyInstances.clear();
        for (int i = 0; i <= portions.length; ++i) {
            double portion = i < portions.length ? portions[i] : 1.0 - sum;
            int numberOfItems = (int)Math.floor((double)data.size() * portion);
            ArrayList<Integer> fold = new ArrayList<Integer>(numberOfItems);
            for (int j = 0; j < numberOfItems; ++j) {
                fold.add((Integer)indices.poll());
            }
            folds[i] = fold;
        }
        while (!indices.isEmpty()) {
            folds[rand.nextInt(folds.length)].add((Integer)indices.poll());
        }
        if (debug && Arrays.asList(folds).stream().mapToInt(Collection::size).sum() != data.size()) {
            throw new IllegalStateException(MSG_DEVIATING_NUMBER_OF_INSTANCES);
        }
        return folds;
    }

    public static List<IWekaInstances> realizeSplit(IWekaInstances data, Collection<Integer>[] split) {
        return WekaUtil.realizeSplitAsCopiedInstances(data, split);
    }

    public static List<Instances> realizeSplit(Instances data, List<List<Integer>> split) {
        return WekaUtil.realizeSplitAsCopiedInstances(data, split);
    }

    public static List<Instances> realizeSplitAsCopiedInstances(Instances data, List<List<Integer>> split) {
        ArrayList<Instances> folds = new ArrayList<Instances>();
        for (Collection collection : split) {
            Instances fold = new Instances(data, 0);
            collection.stream().forEach(i -> fold.add(data.get(i.intValue())));
            folds.add(fold);
        }
        return folds;
    }

    public static List<IWekaInstances> realizeSplitAsCopiedInstances(IWekaInstances data, Collection<Integer>[] split) {
        ArrayList<Instances> folds = new ArrayList<Instances>();
        for (Collection<Integer> foldIndices : split) {
            Instances fold = new Instances(data.getList(), 0);
            foldIndices.stream().forEach(i -> fold.add(((IWekaInstance)data.get((int)i)).getElement()));
            folds.add(fold);
        }
        return folds.stream().map(WekaInstances::new).collect(Collectors.toList());
    }

    public static ArrayNode splitToJsonArray(Collection<Integer>[] splitDecision) {
        ObjectMapper om = new ObjectMapper();
        ArrayNode an = om.createArrayNode();
        splitDecision[0].stream().sorted().forEach(arg_0 -> ((ArrayNode)an).add(arg_0));
        return an;
    }

    public static List<Instances> getStratifiedSplit(Instances data, long seed, double portionOfFirstFold) throws SplitFailedException, InterruptedException {
        return WekaUtil.getStratifiedSplit((IWekaInstances)new WekaInstances(data), new Random(seed), portionOfFirstFold).stream().map(IWekaInstances::getInstances).collect(Collectors.toList());
    }

    public static List<IWekaInstances> getStratifiedSplit(IWekaInstances data, long seed, double portionOfFirstFold) throws SplitFailedException, InterruptedException {
        return WekaUtil.getStratifiedSplit(data, new Random(seed), portionOfFirstFold);
    }

    public static List<IWekaInstances> getStratifiedSplit(IWekaInstances data, Random random, double portionOfFirstFold) throws SplitFailedException, InterruptedException {
        try {
            ArrayList<Instances> split = new ArrayList<Instances>();
            LabelBasedStratifiedSampling sampler = new LabelBasedStratifiedSampling(random, (ILabeledDataset)data);
            sampler.setSampleSize((int)Math.ceil(portionOfFirstFold * (double)data.size()));
            split.add(((IWekaInstances)sampler.call()).getList());
            split.add(((IWekaInstances)sampler.getComplementOfLastSample()).getList());
            if (((Instances)split.get(0)).size() + ((Instances)split.get(1)).size() != data.size()) {
                throw new IllegalStateException("The sum of fold sizes does not correspond to the size of the original dataset!");
            }
            return split.stream().map(WekaInstances::new).collect(Collectors.toList());
        }
        catch (ClassCastException | DatasetCreationException | AlgorithmException | AlgorithmExecutionCanceledException | AlgorithmTimeoutedException e) {
            throw new SplitFailedException(e);
        }
    }

    public static List<File> getDatasetsInFolder(File folder) throws IOException {
        ArrayList files = new ArrayList();
        try (Stream<Path> paths = Files.walk(folder.toPath(), new FileVisitOption[0]);){
            paths.filter(f -> f.getParent().toFile().equals(folder) && f.toFile().getAbsolutePath().endsWith(".arff")).forEach(f -> files.add(f.toFile()));
        }
        return files.stream().sorted().collect(Collectors.toList());
    }

    public static Instances getRefactoredInstances(Instances data, Map<String, String> classMap) {
        ArrayList<String> targetClasses = new ArrayList<String>(new HashSet<String>(classMap.values()));
        Instances childData = WekaUtil.getEmptySetOfInstancesWithRefactoredClass(data, targetClasses);
        for (Instance i : data) {
            String className = i.classAttribute().value((int)Math.round(i.classValue()));
            if (!classMap.containsKey(className)) continue;
            Instance iNew = WekaUtil.getRefactoredInstance(i, targetClasses);
            iNew.setClassValue(classMap.get(className));
            iNew.setDataset(childData);
            childData.add(iNew);
        }
        return childData;
    }

    public static Instance getRefactoredInstance(Instance instance) {
        return WekaUtil.getRefactoredInstance(instance, Arrays.asList("0.0", "1.0"));
    }

    public static Instance getRefactoredInstance(Instance instance, List<String> classes) {
        Instances dataset = WekaUtil.getEmptySetOfInstancesWithRefactoredClass(instance.dataset(), classes);
        int numAttributes = instance.numAttributes();
        int classIndex = instance.classIndex();
        DenseInstance iNew = new DenseInstance(numAttributes);
        for (int i = 0; i < numAttributes; ++i) {
            Attribute a = instance.attribute(i);
            if (i != classIndex) {
                iNew.setValue(a, instance.value(a));
                continue;
            }
            iNew.setValue(a, 0.0);
        }
        dataset.add((Instance)iNew);
        iNew.setDataset(dataset);
        return iNew;
    }

    public static Instances getEmptySetOfInstancesWithRefactoredClass(Instances instances) {
        return WekaUtil.getEmptySetOfInstancesWithRefactoredClass(instances, Arrays.asList("0.0", "1.0"));
    }

    public static Instances getEmptySetOfInstancesWithRefactoredClass(Instances instances, List<String> classes) {
        List<Attribute> newAttributes = WekaUtil.getAttributes(instances, false);
        newAttributes.add(instances.classIndex(), WekaUtil.getNewClassAttribute(instances.classAttribute(), classes));
        Instances newData = new Instances("split", (ArrayList)newAttributes, 0);
        newData.setClassIndex(instances.classIndex());
        return newData;
    }

    public static List<Attribute> getAttributes(Instances inst, boolean includeClassAttribute) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Enumeration e = inst.enumerateAttributes();
        while (e.hasMoreElements()) {
            attributes.add((Attribute)e.nextElement());
        }
        if (includeClassAttribute) {
            attributes.add(inst.classAttribute());
        }
        return attributes;
    }

    public static List<Attribute> getAttributes(Instance inst) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Enumeration e = inst.enumerateAttributes();
        while (e.hasMoreElements()) {
            attributes.add((Attribute)e.nextElement());
        }
        return attributes;
    }

    public static boolean hasOnlyNumericAttributes(Instances instances) {
        for (Attribute a : WekaUtil.getAttributes(instances, false)) {
            if (a.isNumeric()) continue;
            return false;
        }
        return true;
    }

    public static Attribute getNewClassAttribute(Attribute attribute) {
        List<String> vals = Arrays.asList("0.0", "1.0");
        return WekaUtil.getNewClassAttribute(attribute, vals);
    }

    public static Attribute getNewClassAttribute(Attribute attribute, List<String> classes) {
        return new Attribute(attribute.name(), classes);
    }

    public static List<Attribute> getReplacedAttributeList(List<Attribute> attributes, Attribute classAttribute) {
        ArrayList<Attribute> newAttributes = new ArrayList<Attribute>();
        for (Attribute a : attributes) {
            if (classAttribute != a) {
                newAttributes.add(a);
                continue;
            }
            newAttributes.add(WekaUtil.getNewClassAttribute(classAttribute));
        }
        return newAttributes;
    }

    public static Instances mergeClassesOfInstances(Instances data, Collection<String> cluster1, Collection<String> cluster2) {
        Instances newData = WekaUtil.getEmptySetOfInstancesWithRefactoredClass(data);
        for (Instance i : data) {
            Instance iNew = (Instance)i.copy();
            String className = i.classAttribute().value((int)Math.round(i.classValue()));
            if (cluster1.contains(className)) {
                iNew.setClassValue(0.0);
                newData.add(iNew);
                continue;
            }
            if (!cluster2.contains(className)) continue;
            iNew.setClassValue(1.0);
            newData.add(iNew);
        }
        return newData;
    }

    public static Instances mergeClassesOfInstances(Instances data, List<Set<String>> instancesCluster) {
        LinkedList<String> classes = new LinkedList<String>();
        IntStream.range(0, instancesCluster.size()).forEach(x -> classes.add("C" + (double)x));
        Instances newData = WekaUtil.getEmptySetOfInstancesWithRefactoredClass(data, classes);
        for (Instance i : data) {
            Instance iNew = (Instance)i.copy();
            String className = i.classAttribute().value((int)Math.round(i.classValue()));
            for (Set<String> cluster : instancesCluster) {
                if (!cluster.contains(className)) continue;
                iNew.setClassValue((double)instancesCluster.indexOf(cluster));
                iNew.setDataset(newData);
                newData.add(iNew);
            }
        }
        return newData;
    }

    public static List<String> getClassesDeclaredInDataset(Instances data) {
        ArrayList<String> classes = new ArrayList<String>();
        Attribute classAttribute = data.classAttribute();
        for (int i = 0; i < classAttribute.numValues(); ++i) {
            classes.add(classAttribute.value(i));
        }
        return classes;
    }

    public static Collection<String> getClassesActuallyContainedInDataset(Instances data) {
        Map<String, Integer> counter = WekaUtil.getNumberOfInstancesPerClass(data);
        return counter.keySet().stream().filter(k -> (Integer)counter.get(k) != 0).collect(Collectors.toList());
    }

    public static double[] getClassesAsArray(Instances inst) {
        int n = inst.size();
        double[] vec = new double[n];
        for (int i = 0; i < n; ++i) {
            vec[i] = inst.get(i).classValue();
        }
        return vec;
    }

    public static List<Double> getClassesAsList(Instances inst) {
        return inst.stream().map(Instance::classValue).collect(Collectors.toList());
    }

    public static boolean areInstancesEqual(Instance a, Instance b) {
        int n = a.numAttributes();
        if (b == null || b.numAttributes() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (a.value(i) == b.value(i)) continue;
            return false;
        }
        return true;
    }

    public static String instancesToJsonString(Instances data) {
        StringBuilder sb = new StringBuilder();
        JSONNode json = JSONInstances.toJSON((Instances)data);
        json.getChild("header").removeFromParent();
        StringBuffer buffer = new StringBuffer();
        json.toString(buffer);
        sb.append(buffer.toString());
        sb.append("\n");
        return sb.toString();
    }

    public static Instances jsonStringToInstances(String json) throws Exception {
        JSONNode node = JSONNode.read((Reader)new BufferedReader(new StringReader(json)));
        return JSONInstances.toInstances((JSONNode)node);
    }

    public static int[] getIndicesOfContainedInstances(Instances dataset, Instances subset) {
        int[] indices = new int[subset.size()];
        InstanceComparator comp = new InstanceComparator();
        for (int i = 0; i < indices.length; ++i) {
            Instance inst = subset.get(i);
            int index = -1;
            for (int j = 0; j < dataset.size(); ++j) {
                if (comp.compare(inst, dataset.get(j)) != 0) continue;
                index = j;
                break;
            }
            if (index == -1) {
                throw new IllegalArgumentException("The instance " + inst + " is not contained in the given dataset.");
            }
            indices[i] = index;
        }
        return indices;
    }

    public static Instance useFilterOnSingleInstance(Instance instance, Filter filter) throws Exception {
        Instances data = new Instances(instance.dataset());
        data.clear();
        data.add(instance);
        Instances filteredInstances = Filter.useFilter((Instances)data, (Filter)filter);
        return filteredInstances.firstInstance();
    }

    public static Instances removeAttribute(Instances data, int attribute) throws Exception {
        Remove remove = new Remove();
        remove.setAttributeIndices("" + (attribute + 1));
        remove.setInputFormat(data);
        return Filter.useFilter((Instances)data, (Filter)remove);
    }

    public static Instances removeAttributes(Instances data, Collection<Integer> attributes) throws Exception {
        Remove remove = new Remove();
        StringBuilder sb = new StringBuilder();
        for (int att : attributes) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(att + 1);
        }
        remove.setAttributeIndices(sb.toString());
        remove.setInputFormat(data);
        return Filter.useFilter((Instances)data, (Filter)remove);
    }

    public static Instances removeClassAttribute(Instances data) throws Exception {
        if (data.classIndex() < 0) {
            throw new IllegalArgumentException("Class index of data is not set!");
        }
        Remove remove = new Remove();
        remove.setAttributeIndices("" + (data.classIndex() + 1));
        remove.setInputFormat(data);
        return Filter.useFilter((Instances)data, (Filter)remove);
    }

    public static Instance removeClassAttribute(Instance inst) throws Exception {
        Remove remove = new Remove();
        remove.setAttributeIndices("" + (inst.classIndex() + 1));
        remove.setInputFormat(inst.dataset());
        return WekaUtil.useFilterOnSingleInstance(inst, (Filter)remove);
    }

    public static Classifier cloneClassifier(Classifier c) throws Exception {
        Method cloneMethod = MethodUtils.getAccessibleMethod(c.getClass(), (String)"clone", (Class[])new Class[0]);
        if (cloneMethod != null) {
            return (Classifier)cloneMethod.invoke((Object)c, new Object[0]);
        }
        return AbstractClassifier.makeCopy((Classifier)c);
    }

    public static int[] getIndicesOfSubset(Instances data, Instances subset) {
        InstanceComparator comp = new InstanceComparator();
        ArrayList copy = new ArrayList(subset);
        int[] result = new int[subset.size()];
        int row = 0;
        int i = 0;
        for (Instance ref : data) {
            for (int j = 0; j < copy.size(); ++j) {
                Instance inst = (Instance)copy.get(j);
                if (inst == null || comp.compare(inst, ref) != 0) continue;
                result[i++] = row;
                copy.remove(inst);
            }
            ++row;
        }
        return result;
    }

    public static String printNestedWekaClassifier(Classifier c) {
        StringBuilder sb = new StringBuilder();
        sb.append(c.getClass().getName());
        sb.append("(");
        if (c instanceof SingleClassifierEnhancer) {
            sb.append(WekaUtil.printNestedWekaClassifier(((SingleClassifierEnhancer)c).getClassifier()));
        } else if (c instanceof SMO) {
            sb.append(((SMO)c).getKernel().getClass().getName());
        } else if (c instanceof MultipleClassifiersCombiner) {
            sb.append(WekaUtil.printNestedWekaClassifier(((MultipleClassifiersCombiner)c).getClassifier(0)));
        }
        sb.append(")");
        return sb.toString();
    }

    public static boolean isDebug() {
        return debug;
    }

    public static void setDebug(boolean debug) {
        WekaUtil.debug = debug;
    }
}

