/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.weka.classification.pipeline;

import ai.libs.jaicore.ml.weka.WekaUtil;
import ai.libs.jaicore.ml.weka.classification.pipeline.FeaturePreprocessor;
import ai.libs.jaicore.ml.weka.classification.pipeline.PreprocessingException;
import java.io.Serializable;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeSelection;
import weka.core.Instance;
import weka.core.Instances;

public class SupervisedFilterSelector
implements Serializable,
FeaturePreprocessor {
    private final ASSearch searcher;
    private final ASEvaluation evaluator;
    private final AttributeSelection selector;
    private boolean prepared;

    public SupervisedFilterSelector(ASSearch searcher, ASEvaluation evaluator) {
        this.searcher = searcher;
        this.evaluator = evaluator;
        this.selector = new AttributeSelection();
        this.selector.setSearch(searcher);
        this.selector.setEvaluator(evaluator);
    }

    public SupervisedFilterSelector(ASSearch searcher, ASEvaluation evaluator, AttributeSelection selector) {
        this.searcher = searcher;
        this.evaluator = evaluator;
        this.selector = selector;
    }

    public ASSearch getSearcher() {
        return this.searcher;
    }

    public ASEvaluation getEvaluator() {
        return this.evaluator;
    }

    public AttributeSelection getSelector() {
        return this.selector;
    }

    @Override
    public void prepare(Instances data) throws PreprocessingException {
        try {
            this.selector.SelectAttributes(data);
        }
        catch (Exception e) {
            throw new PreprocessingException(e);
        }
        this.prepared = true;
    }

    @Override
    public Instance apply(Instance data) throws PreprocessingException {
        if (!this.prepared) {
            throw new IllegalStateException("Cannot apply preprocessor before it has been prepared!");
        }
        try {
            return this.selector.reduceDimensionality(data);
        }
        catch (Exception e) {
            throw new PreprocessingException(e);
        }
    }

    @Override
    public Instances apply(Instances data) throws PreprocessingException {
        if (!this.prepared) {
            throw new IllegalStateException("Cannot apply preprocessor before it has been prepared!");
        }
        try {
            return this.selector.reduceDimensionality(data);
        }
        catch (Exception e) {
            throw new PreprocessingException(e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.evaluator == null ? 0 : this.evaluator.hashCode());
        result = 31 * result + (this.searcher == null ? 0 : this.searcher.hashCode());
        result = 31 * result + (this.selector == null ? 0 : this.selector.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SupervisedFilterSelector other = (SupervisedFilterSelector)obj;
        if (this.evaluator == null ? other.evaluator != null : !this.evaluator.equals(other.evaluator)) {
            return false;
        }
        if (this.searcher == null ? other.searcher != null : !this.searcher.equals(other.searcher)) {
            return false;
        }
        return !(this.selector == null ? other.selector != null : !this.selector.equals(other.selector));
    }

    @Override
    public boolean isPrepared() {
        return this.prepared;
    }

    public void setPrepared(boolean prepared) {
        this.prepared = prepared;
    }

    public String toString() {
        return "SupervisedFilterSelector [searcher=" + WekaUtil.getPreprocessorDescriptor(this.searcher) + ", evaluator=" + WekaUtil.getPreprocessorDescriptor(this.evaluator) + "]";
    }
}

