/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.weka.rangequery.learner.intervaltree.featurespace;

import ai.libs.jaicore.ml.weka.rangequery.learner.intervaltree.featurespace.CategoricalFeatureDomain;
import ai.libs.jaicore.ml.weka.rangequery.learner.intervaltree.featurespace.FeatureDomain;
import ai.libs.jaicore.ml.weka.rangequery.learner.intervaltree.featurespace.NumericFeatureDomain;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public class FeatureSpace
implements Serializable {
    private static final long serialVersionUID = -4130427099174860007L;
    private List<FeatureDomain> featureDomains = new ArrayList<FeatureDomain>();

    public FeatureSpace() {
    }

    public FeatureSpace(Instances data) {
        this();
        for (int i = 0; i < data.numAttributes(); ++i) {
            Attribute attr = data.attribute(i);
            if (data.classIndex() == i) continue;
            if (attr.isNumeric()) {
                double max;
                double min;
                if (attr.getLowerNumericBound() < attr.getUpperNumericBound()) {
                    min = attr.getLowerNumericBound();
                    max = attr.getUpperNumericBound();
                } else {
                    min = data.attributeStats((int)i).numericStats.min;
                    max = data.attributeStats((int)i).numericStats.max;
                }
                NumericFeatureDomain domain = new NumericFeatureDomain(true, min, max);
                domain.setName(attr.name());
                this.featureDomains.add(domain);
                continue;
            }
            if (attr.isNominal()) {
                String[] attrVals = new String[attr.numValues()];
                double[] internalVals = new double[attr.numValues()];
                for (int valIndex = 0; valIndex < attr.numValues(); ++valIndex) {
                    attrVals[valIndex] = attr.value(valIndex);
                    internalVals[valIndex] = valIndex;
                }
                CategoricalFeatureDomain domain = new CategoricalFeatureDomain(internalVals);
                domain.setName(attr.name());
                this.featureDomains.add(domain);
                continue;
            }
            throw new IllegalArgumentException("Attribute type not supported!");
        }
    }

    public FeatureSpace(List<FeatureDomain> domains) {
        for (FeatureDomain domain : domains) {
            if (domain instanceof NumericFeatureDomain) {
                NumericFeatureDomain numDomain = (NumericFeatureDomain)domain;
                this.featureDomains.add(new NumericFeatureDomain(numDomain));
                continue;
            }
            if (!(domain instanceof CategoricalFeatureDomain)) continue;
            CategoricalFeatureDomain catDomain = (CategoricalFeatureDomain)domain;
            this.featureDomains.add(new CategoricalFeatureDomain(catDomain));
        }
    }

    public FeatureSpace(FeatureSpace space) {
        this(Arrays.asList(space.getFeatureDomains()));
    }

    public FeatureSpace(FeatureDomain[] domains) {
        this(Arrays.asList(domains));
    }

    public FeatureDomain[] toArray() {
        return this.featureDomains.toArray(new FeatureDomain[0]);
    }

    public void add(FeatureDomain domain) {
        this.featureDomains.add(domain);
    }

    public FeatureDomain[] getFeatureDomains() {
        return this.featureDomains.toArray(new FeatureDomain[this.featureDomains.size()]);
    }

    public double getRangeSize() {
        double size = 1.0;
        for (FeatureDomain domain : this.featureDomains) {
            size *= domain.getRangeSize();
        }
        return size;
    }

    public double getRangeSizeOfFeatureSubspace(Set<Integer> featureIndices) {
        double size = 1.0;
        for (int featureIndex : featureIndices) {
            size *= this.featureDomains.get(featureIndex).getRangeSize();
        }
        return size;
    }

    public double getRangeSizeOfAllButSubset(Set<Integer> featureIndices) {
        double size = 1.0;
        for (int i = 0; i < this.getDimensionality(); ++i) {
            if (featureIndices.contains(i)) continue;
            size *= this.featureDomains.get(i).getRangeSize();
        }
        return size;
    }

    public int getDimensionality() {
        return this.featureDomains.size();
    }

    public FeatureDomain getFeatureDomain(int index) {
        return this.featureDomains.get(index);
    }

    public boolean containsPartialInstance(List<Integer> indices, List<Double> values) {
        for (int i = 0; i < indices.size(); ++i) {
            int featureIndex = indices.get(i);
            double value = values.get(i);
            if (this.featureDomains.get(featureIndex).containsInstance(value)) continue;
            return false;
        }
        return true;
    }

    public boolean containsInstance(Instance instance) {
        boolean val = true;
        for (int i = 0; i < this.featureDomains.size(); ++i) {
            FeatureDomain domain = this.featureDomains.get(i);
            val &= domain.contains(instance.value(i));
        }
        return val;
    }
}

