/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.weka.rangequery.learner.intervaltree.featurespace;

import ai.libs.jaicore.ml.weka.rangequery.learner.intervaltree.featurespace.FeatureDomain;

public class NumericFeatureDomain
extends FeatureDomain {
    private final boolean isInteger;
    private double min;
    private double max;

    public NumericFeatureDomain(boolean isInteger, double min, double max) {
        this.isInteger = isInteger;
        this.min = min;
        this.max = max;
    }

    public NumericFeatureDomain(NumericFeatureDomain domain) {
        this.isInteger = domain.isInteger;
        this.min = domain.min;
        this.max = domain.max;
    }

    public boolean isInteger() {
        return this.isInteger;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public String toString() {
        return "NumericFeatureDomain [isInteger=" + this.isInteger + ", min=" + this.min + ", max=" + this.max + "]";
    }

    @Override
    public boolean contains(Object item) {
        if (!(item instanceof Number)) {
            return false;
        }
        Double n = (Double)item;
        return n >= this.min && n <= this.max;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isInteger ? 1231 : 1237);
        long temp = Double.doubleToLongBits(this.max);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.min);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumericFeatureDomain other = (NumericFeatureDomain)obj;
        if (this.isInteger != other.isInteger) {
            return false;
        }
        if (Double.doubleToLongBits(this.max) != Double.doubleToLongBits(other.max)) {
            return false;
        }
        return Double.doubleToLongBits(this.min) == Double.doubleToLongBits(other.min);
    }

    @Override
    public double getRangeSize() {
        double temp = this.max - this.min;
        if (temp == 0.0) {
            return 1.0;
        }
        return temp;
    }

    @Override
    public boolean containsInstance(double value) {
        return value >= this.min && value <= this.max;
    }

    @Override
    public String compactString() {
        return "[" + this.min + "," + this.max + "]";
    }
}

