/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.weka.rangequery.learner.intervaltree.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.math3.geometry.euclidean.oned.Interval;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public class RQPHelper {
    private RQPHelper() {
    }

    public static final IntervalAndHeader mapWEKAToTree(Instance data) {
        Interval[] mappedData = new Interval[data.numAttributes() / 2];
        int counter = 0;
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute("bias"));
        for (int attrNum = 0; attrNum < data.numAttributes(); attrNum += 2) {
            mappedData[counter] = new Interval(data.value(attrNum), data.value(attrNum + 1));
            attributes.add(new Attribute("xVal" + counter));
            ++counter;
        }
        Instances header = new Instances("queriedInterval", attributes, 2);
        header.setClassIndex(-1);
        return new IntervalAndHeader(mappedData, header);
    }

    public static final Interval[] substituteInterval(Interval[] original, Interval toSubstitute, int index) {
        Interval[] copy = Arrays.copyOf(original, original.length);
        copy[index] = toSubstitute;
        return copy;
    }

    public static final <T> Map.Entry<Interval[], T> getEntry(Interval[] interval, T tree) {
        return new AbstractMap.SimpleEntry<Interval[], T>(interval, tree);
    }

    public static class IntervalAndHeader {
        private final Interval[] intervals;
        private final Instances headerInformation;

        public IntervalAndHeader(Interval[] intervals, Instances headerInformation) {
            this.intervals = intervals;
            this.headerInformation = headerInformation;
        }

        public Interval[] getIntervals() {
            return this.intervals;
        }

        public Instances getHeaderInformation() {
            return this.headerInformation;
        }
    }
}

