/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.ranking.dyad.learner.activelearning;

import ai.libs.jaicore.ml.ranking.dyad.dataset.DyadRankingDataset;
import ai.libs.jaicore.ml.ranking.dyad.dataset.SparseDyadRankingInstance;
import ai.libs.jaicore.ml.ranking.dyad.learner.activelearning.ARandomlyInitializingDyadRanker;
import ai.libs.jaicore.ml.ranking.dyad.learner.activelearning.IDyadRankingPoolProvider;
import ai.libs.jaicore.ml.ranking.dyad.learner.algorithm.PLNetDyadRanker;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Random;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledInstance;
import org.api4.java.ai.ml.core.exception.TrainingException;
import org.api4.java.ai.ml.ranking.dyad.dataset.IDyad;
import org.api4.java.ai.ml.ranking.dyad.dataset.IDyadRankingInstance;
import org.api4.java.common.math.IVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.clusterers.Clusterer;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class ConfidenceIntervalClusteringBasedActiveDyadRanker
extends ARandomlyInitializingDyadRanker {
    private static final Logger log = LoggerFactory.getLogger(ConfidenceIntervalClusteringBasedActiveDyadRanker.class);
    private Clusterer clusterer;

    public ConfidenceIntervalClusteringBasedActiveDyadRanker(PLNetDyadRanker ranker, IDyadRankingPoolProvider poolProvider, int seed, int numberRandomQueriesAtStart, int minibatchSize, Clusterer clusterer) {
        super(ranker, poolProvider, seed, numberRandomQueriesAtStart, minibatchSize);
        this.clusterer = clusterer;
    }

    public void activelyTrainWithOneInstance() throws InterruptedException {
        PriorityQueue<List<IDyad>> clusterQueue = new PriorityQueue<List<IDyad>>(new ListComparator());
        DyadRankingDataset minibatch = new DyadRankingDataset();
        Map dyadStats = this.getDyadStats();
        for (IVector inst : this.getInstanceFeatures()) {
            Attribute upperAttr = new Attribute("upper_bound");
            Attribute lowerAttr = new Attribute("lower_bound");
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            attributes.add(upperAttr);
            attributes.add(lowerAttr);
            Instances intervalInstances = new Instances("confidence_intervalls", attributes, this.poolProvider.getDyadsByInstance(inst).size());
            for (IDyad dyad : this.poolProvider.getDyadsByInstance(inst)) {
                double skill = this.ranker.getSkillForDyad(dyad);
                ((SummaryStatistics)dyadStats.get(dyad)).addValue(skill);
                double[] attValues = new double[]{skill + ((SummaryStatistics)dyadStats.get(dyad)).getStandardDeviation(), skill - ((SummaryStatistics)dyadStats.get(dyad)).getStandardDeviation()};
                DenseInstance intervalInstance = new DenseInstance(1.0, attValues);
                intervalInstances.add((Instance)intervalInstance);
            }
            try {
                this.clusterer.buildClusterer(intervalInstances);
                ArrayList instanceClusters = new ArrayList();
                int numClusters = this.clusterer.numberOfClusters();
                for (int clusterIndex = 0; clusterIndex < numClusters; ++clusterIndex) {
                    instanceClusters.add(new ArrayList());
                }
                for (IDyad dyad : this.poolProvider.getDyadsByInstance(inst)) {
                    double skill = this.ranker.getSkillForDyad(dyad);
                    double[] attValues = new double[]{skill + ((SummaryStatistics)dyadStats.get(dyad)).getStandardDeviation(), skill - ((SummaryStatistics)dyadStats.get(dyad)).getStandardDeviation()};
                    DenseInstance intervalInstance = new DenseInstance(1.0, attValues);
                    int cluster = this.clusterer.clusterInstance((Instance)intervalInstance);
                    ((List)instanceClusters.get(cluster)).add(dyad);
                }
                for (int j = 0; j < instanceClusters.size(); ++j) {
                    clusterQueue.add((List)instanceClusters.get(j));
                }
            }
            catch (Exception e1) {
                log.error(e1.getMessage());
            }
        }
        Random random = this.getRandom();
        for (int minibatchIndex = 0; minibatchIndex < this.getMinibatchSize(); ++minibatchIndex) {
            List<IDyad> curDyads = clusterQueue.poll();
            if (curDyads.size() < 2) continue;
            double curMax = -1.0;
            int[] curPair = new int[]{0, 1};
            boolean changed = false;
            for (int j = 1; j < curDyads.size(); ++j) {
                for (int k = 0; k < j; ++k) {
                    IDyad dyad2;
                    IDyad dyad1 = curDyads.get(j);
                    double overlap = this.getConfidenceIntervalOverlapForDyads(dyad1, dyad2 = curDyads.get(k));
                    if (!(overlap > curMax)) continue;
                    curPair[0] = j;
                    curPair[1] = k;
                    curMax = overlap;
                    changed = true;
                }
            }
            if (!changed) {
                curPair[0] = random.nextInt(curDyads.size());
                curPair[1] = random.nextInt(curDyads.size());
                while (curPair[0] == curPair[1]) {
                    curPair[1] = random.nextInt(curDyads.size());
                }
            }
            LinkedList<IVector> alternatives = new LinkedList<IVector>();
            alternatives.add(curDyads.get(curPair[0]).getAlternative());
            alternatives.add(curDyads.get(curPair[1]).getAlternative());
            SparseDyadRankingInstance queryInstance = new SparseDyadRankingInstance(curDyads.get(curPair[0]).getContext(), alternatives);
            IDyadRankingInstance trueRanking = (IDyadRankingInstance)this.poolProvider.query((ILabeledInstance)queryInstance);
            minibatch.add((ILabeledInstance)trueRanking);
        }
        try {
            this.updateRanker(minibatch);
        }
        catch (TrainingException e) {
            log.error(e.getMessage());
        }
    }

    private double getConfidenceIntervalOverlapForDyads(IDyad dyad1, IDyad dyad2) {
        double skill1 = this.ranker.getSkillForDyad(dyad1);
        double skill2 = this.ranker.getSkillForDyad(dyad2);
        Map dyadStats = this.getDyadStats();
        double lower1 = skill1 - ((SummaryStatistics)dyadStats.get(dyad1)).getStandardDeviation();
        double upper1 = skill1 + ((SummaryStatistics)dyadStats.get(dyad1)).getStandardDeviation();
        double lower2 = skill2 - ((SummaryStatistics)dyadStats.get(dyad2)).getStandardDeviation();
        double upper2 = skill2 + ((SummaryStatistics)dyadStats.get(dyad2)).getStandardDeviation();
        if (lower1 > upper2 || upper1 < lower2) {
            return 0.0;
        }
        double upperlower = Math.max(lower1, lower2);
        double lowerupper = Math.min(upper1, upper2);
        return Math.abs(lowerupper - upperlower);
    }

    private class ListComparator
    implements Comparator<List<IDyad>> {
        private ListComparator() {
        }

        @Override
        public int compare(List<IDyad> o1, List<IDyad> o2) {
            if (o1.size() > o2.size()) {
                return -1;
            }
            if (o1.size() < o2.size()) {
                return 1;
            }
            return 0;
        }
    }
}

