/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.weka.dataset;

import ai.libs.jaicore.ml.core.dataset.schema.LabeledInstanceSchema;
import ai.libs.jaicore.ml.core.dataset.schema.attribute.IntBasedCategoricalAttribute;
import ai.libs.jaicore.ml.core.dataset.schema.attribute.NumericAttribute;
import ai.libs.jaicore.ml.weka.dataset.WekaInstance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.api4.java.ai.ml.core.dataset.schema.ILabeledInstanceSchema;
import org.api4.java.ai.ml.core.dataset.schema.attribute.IAttribute;
import org.api4.java.ai.ml.core.dataset.schema.attribute.ICategoricalAttribute;
import org.api4.java.ai.ml.core.dataset.schema.attribute.INumericAttribute;
import org.api4.java.ai.ml.core.dataset.schema.attribute.INumericAttributeValue;
import org.api4.java.ai.ml.core.dataset.serialization.UnsupportedAttributeTypeException;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledInstance;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class WekaInstancesUtil {
    private WekaInstancesUtil() {
    }

    public static ILabeledInstanceSchema extractSchema(Instances dataset) {
        int targetIndex = dataset.classIndex();
        if (targetIndex < 0) {
            throw new IllegalArgumentException("Class index of Instances object is not set!");
        }
        List attributes = IntStream.range(0, dataset.numAttributes()).mapToObj(arg_0 -> ((Instances)dataset).attribute(arg_0)).map(WekaInstancesUtil::transformWEKAAttributeToAttributeType).collect(Collectors.toList());
        IAttribute labelAttribute = (IAttribute)attributes.remove(targetIndex);
        return new LabeledInstanceSchema(dataset.relationName(), attributes, labelAttribute);
    }

    public static Instances datasetToWekaInstances(ILabeledDataset<? extends ILabeledInstance> dataset) throws UnsupportedAttributeTypeException {
        Instances wekaInstances = WekaInstancesUtil.createDatasetFromSchema(dataset.getInstanceSchema());
        int expectedAttributes = dataset.getInstanceSchema().getNumAttributes();
        for (ILabeledInstance inst : dataset) {
            if (inst.getNumAttributes() != expectedAttributes) {
                throw new IllegalStateException("Dataset scheme defines a number of " + expectedAttributes + " attributes, but instance has " + inst.getNumAttributes() + ".");
            }
            double[] point = inst.getPoint();
            double[] pointWithLabel = Arrays.copyOf(point, point.length + 1);
            DenseInstance iNew = new DenseInstance(1.0, pointWithLabel);
            iNew.setDataset(wekaInstances);
            if (dataset.getLabelAttribute() instanceof ICategoricalAttribute) {
                iNew.setClassValue(((ICategoricalAttribute)dataset.getLabelAttribute()).getLabelOfCategory((Number)((Integer)inst.getLabel())));
            } else if (inst.getLabel() != null) {
                iNew.setClassValue(Double.parseDouble(inst.getLabel().toString()));
            }
            wekaInstances.add((Instance)iNew);
        }
        return wekaInstances;
    }

    public static Instances createDatasetFromSchema(ILabeledInstanceSchema schema) throws UnsupportedAttributeTypeException {
        Attribute classAttribute;
        Objects.requireNonNull(schema);
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        for (int i = 0; i < schema.getNumAttributes(); ++i) {
            IAttribute attType = (IAttribute)schema.getAttributeList().get(i);
            if (attType instanceof INumericAttribute) {
                attributes.add(new Attribute(attType.getName()));
                continue;
            }
            if (attType instanceof ICategoricalAttribute) {
                attributes.add(new Attribute(attType.getName(), ((ICategoricalAttribute)attType).getLabels()));
                continue;
            }
            throw new UnsupportedAttributeTypeException("The class attribute has an unsupported attribute type " + attType.getClass().getName() + " of attribute " + attType.getName() + ".");
        }
        IAttribute classType = schema.getLabelAttribute();
        if (classType instanceof INumericAttribute) {
            classAttribute = new Attribute(classType.getName());
        } else if (classType instanceof ICategoricalAttribute) {
            classAttribute = new Attribute(classType.getName(), ((IntBasedCategoricalAttribute)classType).getLabels());
        } else {
            throw new UnsupportedAttributeTypeException("The class attribute has an unsupported attribute type.");
        }
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>(attributes);
        attributeList.add(classAttribute);
        Instances wekaInstances = new Instances("weka-instances", attributeList, 0);
        wekaInstances.setClassIndex(wekaInstances.numAttributes() - 1);
        return wekaInstances;
    }

    public static IAttribute transformWEKAAttributeToAttributeType(Attribute att) {
        String attributeName = att.name();
        if (att.isNumeric()) {
            return new NumericAttribute(attributeName);
        }
        if (att.isNominal()) {
            LinkedList<String> domain = new LinkedList<String>();
            for (int i = 0; i < att.numValues(); ++i) {
                domain.add(att.value(i));
            }
            return new IntBasedCategoricalAttribute(attributeName, domain);
        }
        throw new IllegalArgumentException("Can only transform numeric or categorical attributes");
    }

    public static Instance transformInstanceToWekaInstance(ILabeledInstanceSchema schema, ILabeledInstance instance) throws UnsupportedAttributeTypeException {
        if (instance.getNumAttributes() != schema.getNumAttributes()) {
            throw new IllegalArgumentException("Schema and instance do not coincide. The schema defines " + schema.getNumAttributes() + " attributes but the instance has " + instance.getNumAttributes() + " attributes.");
        }
        if (instance instanceof WekaInstance) {
            return (Instance)((WekaInstance)instance).getElement();
        }
        Objects.requireNonNull(schema);
        Instances dataset = WekaInstancesUtil.createDatasetFromSchema(schema);
        DenseInstance iNew = new DenseInstance(dataset.numAttributes());
        iNew.setDataset(dataset);
        for (int i = 0; i < instance.getNumAttributes(); ++i) {
            INumericAttributeValue value;
            if (schema.getAttribute(i) instanceof INumericAttribute) {
                value = ((INumericAttribute)schema.getAttribute(i)).getAsAttributeValue(instance.getAttributeValue(i));
                if (value != null) {
                    iNew.setValue(i, value.getValue().doubleValue());
                    continue;
                }
                iNew.setMissing(i);
                continue;
            }
            if (schema.getAttribute(i) instanceof ICategoricalAttribute) {
                value = ((ICategoricalAttribute)schema.getAttribute(i)).getAsAttributeValue(instance.getAttributeValue(i));
                if (value != null) {
                    iNew.setValue(i, (double)value.getValue().intValue());
                    continue;
                }
                iNew.setMissing(i);
                continue;
            }
            throw new UnsupportedAttributeTypeException("Only categorical and numeric attributes are supported!");
        }
        if (schema.getLabelAttribute() instanceof INumericAttribute) {
            iNew.setValue(iNew.numAttributes() - 1, ((INumericAttribute)schema.getLabelAttribute()).getAsAttributeValue(instance.getLabel()).getValue().doubleValue());
        } else if (schema.getLabelAttribute() instanceof ICategoricalAttribute) {
            iNew.setValue(iNew.numAttributes() - 1, (double)((ICategoricalAttribute)schema.getLabelAttribute()).getAsAttributeValue(instance.getLabel()).getValue().intValue());
        } else {
            throw new UnsupportedAttributeTypeException("Only categorical and numeric attributes are supported!");
        }
        if (iNew.numClasses() != dataset.numClasses()) {
            throw new IllegalStateException();
        }
        return iNew;
    }
}

