/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.weka.classification.learner;

import ai.libs.jaicore.ml.classification.singlelabel.SingleLabelClassification;
import ai.libs.jaicore.ml.classification.singlelabel.SingleLabelClassificationPredictionBatch;
import ai.libs.jaicore.ml.weka.classification.learner.AWekaLearner;
import ai.libs.jaicore.ml.weka.classification.learner.IWekaClassifier;
import ai.libs.jaicore.ml.weka.classification.pipeline.MLPipeline;
import java.util.HashMap;
import java.util.List;
import java.util.stream.IntStream;
import org.api4.java.ai.ml.classification.singlelabel.evaluation.ISingleLabelClassification;
import org.api4.java.ai.ml.classification.singlelabel.evaluation.ISingleLabelClassificationPredictionBatch;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledInstance;
import org.api4.java.ai.ml.core.exception.PredictionException;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Instance;

public class WekaClassifier
extends AWekaLearner<ISingleLabelClassification, ISingleLabelClassificationPredictionBatch>
implements IWekaClassifier {
    public static WekaClassifier createPipeline(String searcher, List<String> searcherOptions, String evaluator, List<String> evaluatorOptions, String classifier, List<String> classifierOptions) throws Exception {
        ASSearch search = ASSearch.forName((String)searcher, (String[])searcherOptions.toArray(new String[0]));
        ASEvaluation eval = ASEvaluation.forName((String)evaluator, (String[])evaluatorOptions.toArray(new String[0]));
        Classifier c = AbstractClassifier.forName((String)classifier, (String[])classifierOptions.toArray(new String[0]));
        return new WekaClassifier(new MLPipeline(search, eval, c));
    }

    public static WekaClassifier createBaseClassifier(String name, List<String> options) {
        return new WekaClassifier(name, options.toArray(new String[0]));
    }

    public WekaClassifier(String name, String[] options) {
        super(name, options);
    }

    public WekaClassifier(Classifier classifier) {
        super(classifier);
        this.wrappedLearner = classifier;
        this.name = classifier.getClass().getName();
    }

    public ISingleLabelClassification predict(ILabeledInstance xTest) throws PredictionException, InterruptedException {
        try {
            HashMap distribution = new HashMap();
            double[] dist = this.wrappedLearner.distributionForInstance((Instance)this.getWekaInstance(xTest).getElement());
            IntStream.range(0, dist.length).forEach(x -> distribution.put(x, dist[x]));
            return new SingleLabelClassification(distribution);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PredictionException("Could not make a prediction since an exception occurred in the wrapped weka classifier.", (Throwable)e);
        }
    }

    @Override
    protected ISingleLabelClassificationPredictionBatch getPredictionListAsBatch(List<ISingleLabelClassification> predictionList) {
        return new SingleLabelClassificationPredictionBatch(predictionList);
    }
}

