/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.weka.classification.pipeline.featuregen;

import ai.libs.jaicore.ml.weka.classification.pipeline.PreprocessingException;
import ai.libs.jaicore.ml.weka.classification.pipeline.featuregen.FeatureGenerator;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.core.Instance;
import weka.core.Instances;

public class FeatureGeneratorTree
implements FeatureGenerator {
    private static final long serialVersionUID = 3071755243287146060L;
    private final transient Logger logger = LoggerFactory.getLogger(FeatureGeneratorTree.class);
    private final FeatureGenerator root;
    private final List<FeatureGeneratorTree> children = new ArrayList<FeatureGeneratorTree>();
    private boolean prepared;

    public FeatureGeneratorTree(FeatureGenerator root) {
        this.root = root;
    }

    public void addChild(FeatureGenerator child) {
        this.children.add(new FeatureGeneratorTree(child));
    }

    public void removeChild(FeatureGeneratorTree child) {
        this.children.removeIf(c -> c.root.equals(child));
    }

    public FeatureGenerator getRoot() {
        return this.root;
    }

    @Override
    public void prepare(Instances data) throws PreprocessingException {
        this.logger.info("Starting preparation of FeatureGeneratorTree ({}) for {}x{}-matrix.", new Object[]{this.root.getClass().getName(), data.size(), data.numAttributes()});
        try {
            for (FeatureGeneratorTree featureGeneratorTree : this.children) {
                featureGeneratorTree.prepare(data);
            }
            Instances mergedInstances = new Instances(data);
            for (FeatureGeneratorTree child : this.children) {
                Instances instancesGeneratedByChild = child.apply(data);
                mergedInstances = Instances.mergeInstances((Instances)mergedInstances, (Instances)instancesGeneratedByChild);
            }
            this.root.prepare(mergedInstances);
            Instances instances = this.apply(data);
            this.logger.info("Preparation of FeatureGeneratorTree ({}) ready. Result will be a {}x{}-matrix", new Object[]{this.root.getClass().getName(), instances.size(), instances.numAttributes()});
            this.prepared = true;
        }
        catch (Exception e) {
            throw new PreprocessingException(e);
        }
    }

    @Override
    public Instance apply(Instance data) throws PreprocessingException {
        try {
            Instances instances = new Instances(data.dataset());
            instances.clear();
            instances.add(data);
            return this.apply(instances).firstInstance();
        }
        catch (Exception e) {
            throw new PreprocessingException(e);
        }
    }

    @Override
    public Instances apply(Instances data) throws PreprocessingException {
        try {
            Instances mergedInstances = new Instances(data);
            for (FeatureGeneratorTree child : this.children) {
                mergedInstances = Instances.mergeInstances((Instances)mergedInstances, (Instances)child.apply(data));
            }
            return this.root.apply(mergedInstances);
        }
        catch (Exception e) {
            throw new PreprocessingException(e);
        }
    }

    @Override
    public boolean isPrepared() {
        return this.prepared;
    }
}

