/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.weka.classification.learner;

import ai.libs.jaicore.basic.algorithm.AAlgorithm;
import ai.libs.jaicore.basic.algorithm.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.AlgorithmInitializedEvent;
import ai.libs.jaicore.ml.weka.classification.learner.IWekaClassifier;
import ai.libs.jaicore.ml.weka.classification.learner.IWekaLearningAlgorithm;
import ai.libs.jaicore.ml.weka.classification.learner.WekaClassifier;
import ai.libs.jaicore.ml.weka.dataset.WekaInstances;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.api4.java.ai.ml.core.dataset.IDataSource;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledInstance;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;

public class WekaLearningAlgorithm
extends AAlgorithm<ILabeledDataset<?>, IWekaClassifier>
implements IWekaLearningAlgorithm {
    private final Class<?> classifierClass;
    private IWekaClassifier builtModel;
    private FutureTask<?> futureTask;

    public WekaLearningAlgorithm(Class<?> classifierClass, ILabeledDataset<?> input) {
        super(input);
        this.classifierClass = classifierClass;
    }

    public IAlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        ExecutorService executor = null;
        try {
            switch (this.getState()) {
                case CREATED: {
                    this.builtModel = new WekaClassifier(this.classifierClass.getName(), new String[0]);
                    AlgorithmInitializedEvent algorithmInitializedEvent = this.activate();
                    return algorithmInitializedEvent;
                }
                case ACTIVE: {
                    WekaInstances dataset = new WekaInstances((ILabeledDataset<? extends ILabeledInstance>)((ILabeledDataset)this.getInput()));
                    this.futureTask = new FutureTask<Object>(() -> {
                        this.builtModel.fit((IDataSource)dataset);
                        return null;
                    });
                    executor = Executors.newSingleThreadExecutor();
                    executor.submit(this.futureTask);
                    this.futureTask.get(this.getRemainingTimeToDeadline().milliseconds() - 100L, TimeUnit.MILLISECONDS);
                    AlgorithmFinishedEvent algorithmFinishedEvent = this.terminate();
                    return algorithmFinishedEvent;
                }
            }
            try {
                throw new IllegalStateException("Don't know what to do in state " + this.getState() + ".");
            }
            catch (TimeoutException e) {
                throw new AlgorithmTimeoutedException(0L);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (CancellationException e) {
                throw new AlgorithmExecutionCanceledException(0L);
            }
            catch (Exception e) {
                throw new AlgorithmException("Could not build classifier.", (Throwable)e);
            }
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
        }
    }

    public IWekaClassifier call() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        while (this.hasNext()) {
            this.nextWithException();
        }
        return this.builtModel;
    }

    public void cancel() {
        this.futureTask.cancel(true);
        super.cancel();
    }
}

