/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.weka.dataset;

import ai.libs.jaicore.basic.sets.ElementDecorator;
import ai.libs.jaicore.ml.weka.WekaUtil;
import ai.libs.jaicore.ml.weka.dataset.IWekaInstance;
import ai.libs.jaicore.ml.weka.dataset.WekaInstancesUtil;
import java.util.stream.IntStream;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.api4.java.ai.ml.core.dataset.schema.ILabeledInstanceSchema;
import org.api4.java.ai.ml.core.dataset.serialization.UnsupportedAttributeTypeException;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledInstance;
import weka.core.Attribute;
import weka.core.Instance;

public class WekaInstance
extends ElementDecorator<Instance>
implements IWekaInstance {
    public WekaInstance(Instance instance) {
        super((Object)instance);
    }

    public WekaInstance(ILabeledInstanceSchema schema, ILabeledInstance instance) throws UnsupportedAttributeTypeException {
        super((Object)WekaInstancesUtil.transformInstanceToWekaInstance(schema, instance));
        if (schema.getNumAttributes() != instance.getNumAttributes()) {
            throw new IllegalStateException("Number of attributes in the instance deviate from those in the scheme.");
        }
    }

    public Number getLabel() {
        boolean isInteger = ((Instance)this.getElement()).classAttribute().isNominal();
        double classValue = ((Instance)this.getElement()).classValue();
        if (isInteger) {
            int intClassValue = (int)classValue;
            return intClassValue;
        }
        return classValue;
    }

    public Double getAttributeValue(int pos) {
        return ((Instance)this.getElement()).value(pos);
    }

    public Object[] getAttributes() {
        return IntStream.range(0, ((Instance)this.getElement()).numAttributes()).filter(x -> x != ((Instance)this.getElement()).classIndex()).mapToObj(x -> ((Instance)this.getElement()).attribute(x)).map(this::transformAttributeValueToData).toArray();
    }

    private Object transformAttributeValueToData(Attribute att) {
        double internalValue = ((Instance)this.getElement()).value(att);
        return att.isNumeric() ? Double.valueOf(internalValue) : att.value((int)internalValue);
    }

    public double[] getPoint() {
        return ((Instance)this.getElement()).toDoubleArray();
    }

    public double getPointValue(int pos) {
        return ((Instance)this.getElement()).value(pos);
    }

    public void removeColumn(int columnPos) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public void setLabel(Object obj) {
        if (obj instanceof String) {
            ((Instance)this.getElement()).setClassValue((String)obj);
        } else if (obj instanceof Double) {
            ((Instance)this.getElement()).setClassValue(((Double)obj).doubleValue());
        } else {
            throw new IllegalArgumentException("The value for the label must not be of type " + obj.getClass().getName() + ". The only valid types are Double and String.");
        }
    }

    public void setAttributeValue(int pos, Object value) {
        if (value instanceof String) {
            ((Instance)this.getElement()).setValue(pos, (String)value);
        } else if (value instanceof Double) {
            ((Instance)this.getElement()).setValue(pos, ((Double)value).doubleValue());
        } else {
            throw new IllegalArgumentException("The value for the label must not be of type " + value.getClass().getName() + ". The only valid types are Double and String.");
        }
    }

    public int hashCode() {
        return new HashCodeBuilder().append(((Instance)this.getElement()).toDoubleArray()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WekaInstance)) {
            return false;
        }
        return WekaUtil.areInstancesEqual((Instance)this.getElement(), (Instance)((WekaInstance)obj).getElement());
    }

    public String toString() {
        return ((Instance)this.getElement()).toString();
    }
}

