/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.weka.dataset;

import ai.libs.jaicore.basic.reconstruction.ReconstructionInstruction;
import ai.libs.jaicore.basic.reconstruction.ReconstructionPlan;
import ai.libs.jaicore.ml.weka.WekaUtil;
import ai.libs.jaicore.ml.weka.dataset.IWekaInstance;
import ai.libs.jaicore.ml.weka.dataset.IWekaInstances;
import ai.libs.jaicore.ml.weka.dataset.WekaInstance;
import ai.libs.jaicore.ml.weka.dataset.WekaInstancesUtil;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.api4.java.ai.ml.core.dataset.IDataset;
import org.api4.java.ai.ml.core.dataset.schema.ILabeledInstanceSchema;
import org.api4.java.ai.ml.core.dataset.schema.attribute.IAttribute;
import org.api4.java.ai.ml.core.dataset.serialization.UnsupportedAttributeTypeException;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledInstance;
import org.api4.java.ai.ml.core.exception.DatasetCreationException;
import org.api4.java.common.attributedobjects.IListDecorator;
import org.api4.java.common.reconstruction.IReconstructible;
import org.api4.java.common.reconstruction.IReconstructionInstruction;
import org.api4.java.common.reconstruction.IReconstructionPlan;
import weka.core.Instance;
import weka.core.Instances;

public class WekaInstances
implements IWekaInstances,
IListDecorator<Instances, Instance, IWekaInstance>,
IReconstructible {
    private static final long serialVersionUID = -1980814429448333405L;
    private ILabeledInstanceSchema schema;
    private final List<IReconstructionInstruction> reconstructionInstructions;
    private Instances dataset;

    public WekaInstances(Instances dataset) {
        this(dataset, WekaInstancesUtil.extractSchema(dataset));
    }

    public WekaInstances(Instances dataset, ILabeledInstanceSchema schema) {
        this.schema = schema;
        this.dataset = dataset;
        this.reconstructionInstructions = new ArrayList<IReconstructionInstruction>();
    }

    public WekaInstances(ILabeledDataset<? extends ILabeledInstance> dataset) {
        this.schema = dataset.getInstanceSchema();
        if (dataset instanceof WekaInstances) {
            this.dataset = new Instances(((WekaInstances)dataset).dataset);
        } else {
            try {
                this.dataset = WekaInstancesUtil.datasetToWekaInstances(dataset);
            }
            catch (UnsupportedAttributeTypeException e) {
                throw new IllegalArgumentException("Could not convert dataset to weka's Instances.", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Could not finish instantiating weka instances.", e);
            }
        }
        if (this.dataset.numAttributes() != dataset.getNumAttributes() + 1) {
            throw new IllegalStateException("Number of attributes in the WekaInstances do not coincide. We have " + this.dataset.numAttributes() + " while given dataset had " + dataset.getNumAttributes() + ". There should be a difference of 1, because WEKA counts the label as an attribute.");
        }
        this.reconstructionInstructions = dataset instanceof IReconstructible ? ((ReconstructionPlan)((IReconstructible)dataset).getConstructionPlan()).getInstructions() : null;
    }

    @Override
    public Instances getInstances() {
        return this.dataset;
    }

    public void removeColumn(int columnPos) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public IWekaInstances createEmptyCopy() throws DatasetCreationException {
        return new WekaInstances(new Instances(this.dataset, 0));
    }

    public int hashCode() {
        HashCodeBuilder hb = new HashCodeBuilder();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            IWekaInstance inst = (IWekaInstance)iterator.next();
            hb.append(inst.hashCode());
        }
        return hb.toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WekaInstances other = (WekaInstances)obj;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (((IWekaInstance)this.get(i)).equals(other.get(i))) continue;
            return false;
        }
        return true;
    }

    public int getFrequency(IWekaInstance instance) {
        return (int)this.stream().filter(instance::equals).count();
    }

    public String toString() {
        return "WekaInstances [schema=" + this.getInstanceSchema() + "]\n" + this.dataset;
    }

    public Class<IWekaInstance> getTypeOfDecoratingItems() {
        return IWekaInstance.class;
    }

    public Class<Instance> getTypeOfDecoratedItems() {
        return Instance.class;
    }

    public Constructor<? extends IWekaInstance> getConstructorForDecoratingItems() {
        try {
            return WekaInstance.class.getConstructor(this.getTypeOfDecoratedItems());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The constructor of the list class could not be invoked.");
        }
    }

    @Override
    public Instances getList() {
        return this.dataset;
    }

    public IDataset<IWekaInstance> createCopy() throws DatasetCreationException, InterruptedException {
        return new WekaInstances(this);
    }

    public Object[] getLabelVector() {
        return WekaUtil.getClassesAsList(this.dataset).toArray();
    }

    public ILabeledInstanceSchema getInstanceSchema() {
        return this.schema;
    }

    public Object[][] getFeatureMatrix() {
        throw new UnsupportedOperationException();
    }

    public void removeColumn(String columnName) {
        throw new UnsupportedOperationException();
    }

    public void removeColumn(IAttribute attribute) {
        throw new UnsupportedOperationException();
    }

    public IReconstructionPlan getConstructionPlan() {
        return new ReconstructionPlan(this.reconstructionInstructions.stream().map(i -> (ReconstructionInstruction)i).collect(Collectors.toList()));
    }

    public void addInstruction(IReconstructionInstruction instruction) {
        this.reconstructionInstructions.add(instruction);
    }
}

